/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.monitoring;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.SchemaFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;

final class MonitoringSchema {
    private final Schema schema;

    MonitoringSchema(Schema schema) {
        this.schema = schema;
    }

    @XmlElement(name="identifier")
    public String getIdentifier() {
        return this.schema.getIdentifier();
    }

    @XmlElement(name="namespace")
    public String getNamespace() {
        return this.schema.getNamespace().getValue();
    }

    @XmlElement(name="location")
    public Collection<String> getLocation() {
        return Collections2.transform((Collection)this.schema.getLocation(), input -> input.getEnumeration().toString());
    }

    @XmlElement(name="version")
    public String getVersion() {
        return this.schema.getVersion();
    }

    @XmlElement(name="format")
    public String getFormat() {
        SchemaFormat format = this.schema.getFormat();
        Preconditions.checkState((boolean)Yang.VALUE.equals((Object)format), (String)"Only yang format permitted, but was %s", (Object)format);
        return "yang";
    }
}

