/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.monitoring;

import java.util.Map;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.AbstractNetconfOperation;
import org.opendaylight.netconf.server.api.operations.HandlingPriority;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.netconf.test.tool.monitoring.JaxBSerializer;
import org.opendaylight.netconf.test.tool.monitoring.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Get
extends AbstractNetconfOperation {
    private static final Logger LOG = LoggerFactory.getLogger(Get.class);
    private final NetconfMonitoringService netconfMonitor;

    public Get(SessionIdType sessionId, NetconfMonitoringService netconfMonitor) {
        super(sessionId);
        this.netconfMonitor = netconfMonitor;
    }

    protected String getOperationName() {
        return "get";
    }

    protected HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY.increasePriority(1);
    }

    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        if (subsequentOperation == null) {
            throw new DocumentedException(String.format("Subsequent netconf operation expected by %s", new Object[]{this}), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
        try {
            Document innerResult = subsequentOperation.execute(requestMessage);
            NetconfState netconfMonitoring = new NetconfState(this.netconfMonitor);
            Element monitoringXmlElement = JaxBSerializer.toXml(netconfMonitoring);
            monitoringXmlElement = (Element)innerResult.importNode(monitoringXmlElement, true);
            Element monitoringXmlElementPlaceholder = Get.getPlaceholder(innerResult);
            monitoringXmlElementPlaceholder.appendChild(monitoringXmlElement);
            return innerResult;
        }
        catch (RuntimeException e) {
            String errorMessage = "Get operation for netconf-state subtree failed";
            LOG.warn("Get operation for netconf-state subtree failed", (Throwable)e);
            throw new DocumentedException("Get operation for netconf-state subtree failed", (Exception)e, ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR, Map.of(ErrorSeverity.ERROR.elementBody(), e.getMessage()));
        }
    }

    protected Element handle(Document document, XmlElement message, NetconfOperationChainedExecution subsequentOperation) {
        throw new UnsupportedOperationException("Never gets called");
    }

    private static Element getPlaceholder(Document innerResult) throws DocumentedException {
        return XmlElement.fromDomElementWithExpected((Element)innerResult.getDocumentElement(), (String)"rpc-reply", (String)"urn:ietf:params:xml:ns:netconf:base:1.0").getOnlyChildElement("data").getDomElement();
    }
}

