/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.customrpc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.bind.JAXB;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.test.tool.customrpc.Rpc;
import org.opendaylight.netconf.test.tool.customrpc.Rpcs;
import org.opendaylight.netconf.test.tool.customrpc.XmlData;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

class RpcMapping {
    private final Multimap<Request, Document> requestToResponseMap = ArrayListMultimap.create();

    RpcMapping(File config) {
        Rpcs rpcs = (Rpcs)JAXB.unmarshal((File)config, Rpcs.class);
        for (Rpc rpc : rpcs.getRpcs()) {
            Stream<Document> stream = rpc.getOutput().stream().map(XmlData::getData);
            XmlElement element = XmlElement.fromDomDocument((Document)rpc.getInput().getData());
            this.requestToResponseMap.putAll((Object)new Request(element), stream::iterator);
        }
    }

    Optional<Document> getResponse(XmlElement input) {
        Collection responses = this.requestToResponseMap.get((Object)new Request(input));
        Iterator iterator = responses.iterator();
        if (iterator.hasNext()) {
            Document response = (Document)iterator.next();
            if (iterator.hasNext()) {
                iterator.remove();
            }
            return Optional.of(response);
        }
        return Optional.empty();
    }

    private static class Request {
        private final XmlElement xmlElement;
        private final int hashCode;

        Request(XmlElement element) {
            this.xmlElement = element;
            this.hashCode = XmlUtil.toString((XmlElement)element).replaceAll("message-id=.*(>| )", "").replaceAll("\\s+", "").hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Request request = (Request)obj;
            return Request.documentEquals(this.xmlElement, request.xmlElement);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static boolean documentEquals(XmlElement e1, XmlElement e2) {
            if (!Objects.equals(e1.namespace(), e2.namespace())) {
                return false;
            }
            if (!e1.getName().equals(e2.getName())) {
                return false;
            }
            if (Request.attributesNotEquals(e1, e2)) {
                return false;
            }
            List e1Children = e1.getChildElements();
            List e2Children = e2.getChildElements();
            if (e1Children.size() != e2Children.size()) {
                return false;
            }
            Iterator e1Iterator = e1Children.iterator();
            Iterator e2Iterator = e2Children.iterator();
            while (e1Iterator.hasNext() && e2Iterator.hasNext()) {
                if (Request.documentEquals((XmlElement)e1Iterator.next(), (XmlElement)e2Iterator.next())) continue;
                return false;
            }
            if (e1Children.isEmpty() && e2Children.isEmpty()) {
                try {
                    return e1.getTextContent().equals(e2.getTextContent());
                }
                catch (DocumentedException e) {
                    return false;
                }
            }
            return true;
        }

        private static boolean attributesNotEquals(XmlElement e1, XmlElement e2) {
            Map e1Attrs = e1.getAttributes();
            Map e2Attrs = e2.getAttributes();
            Iterator e1AttrIt = e1Attrs.entrySet().iterator();
            Iterator e2AttrIt = e2Attrs.entrySet().iterator();
            while (e1AttrIt.hasNext() && e2AttrIt.hasNext()) {
                Map.Entry e1Next = e1AttrIt.next();
                Map.Entry e2Next = e2AttrIt.next();
                if (((String)e1Next.getKey()).equals("message-id") && ((String)e2Next.getKey()).equals("message-id") || ((String)e1Next.getKey()).equals("xmlns") && ((String)e2Next.getKey()).equals("xmlns")) continue;
                if (!((String)e1Next.getKey()).equals(e2Next.getKey())) {
                    return true;
                }
                if (((Attr)e1Next.getValue()).getValue().equals(((Attr)e2Next.getValue()).getValue())) continue;
                return true;
            }
            return false;
        }
    }
}

