/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.config;

import java.io.File;
import java.util.Set;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.test.tool.TesttoolParameters;
import org.opendaylight.netconf.test.tool.config.Configuration;
import org.opendaylight.netconf.test.tool.config.YangResource;
import org.opendaylight.netconf.test.tool.operations.OperationsCreator;
import org.opendaylight.netconf.test.tool.rpchandler.RpcHandler;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;

public class ConfigurationBuilder {
    private final Configuration configuration = new Configuration();

    public ConfigurationBuilder setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.configuration.setPublickeyAuthenticator(publickeyAuthenticator);
        return this;
    }

    public ConfigurationBuilder setAuthProvider(AuthProvider authProvider) {
        this.configuration.setAuthProvider(authProvider);
        return this;
    }

    public ConfigurationBuilder setGetDefaultYangResources(Set<YangResource> defaultYangResources) {
        this.configuration.setDefaultYangResources(defaultYangResources);
        return this;
    }

    public ConfigurationBuilder setThreadPoolSize(int threadPoolSize) {
        this.configuration.setThreadPoolSize(threadPoolSize);
        return this;
    }

    public ConfigurationBuilder setGenerateConfigsTimeout(int generateConfigsTimeout) {
        this.configuration.setGenerateConfigsTimeout(generateConfigsTimeout);
        return this;
    }

    public ConfigurationBuilder setModels(Set<YangModuleInfo> models) {
        this.configuration.setModels(models);
        return this;
    }

    public ConfigurationBuilder setCapabilities(Set<String> capabilities) {
        this.configuration.setCapabilities(capabilities);
        return this;
    }

    public ConfigurationBuilder setStartingPort(int startingPort) {
        this.configuration.setStartingPort(startingPort);
        return this;
    }

    public ConfigurationBuilder setDeviceCount(int deviceCount) {
        this.configuration.setDeviceCount(deviceCount);
        return this;
    }

    public ConfigurationBuilder setSsh(boolean ssh) {
        this.configuration.setSsh(ssh);
        return this;
    }

    public ConfigurationBuilder setIp(String ip) {
        this.configuration.setIp(ip);
        return this;
    }

    public ConfigurationBuilder setRpcMapping(RpcHandler rpcHandler) {
        this.configuration.setRpcHandler(rpcHandler);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder setMdSal(boolean mdSal) {
        this.configuration.setMdSal(mdSal);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder setRpcConfigFile(File rpcConfigFile) {
        this.configuration.setRpcConfigFile(rpcConfigFile);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder setInitialConfigXMLFile(File initialConfigXMLFile) {
        this.configuration.setInitialConfigXMLFile(initialConfigXMLFile);
        return this;
    }

    @Deprecated
    public ConfigurationBuilder setNotificationFile(File notificationFile) {
        this.configuration.setNotificationFile(notificationFile);
        return this;
    }

    public ConfigurationBuilder setOperationsCreator(OperationsCreator operationsCreator) {
        this.configuration.setOperationsCreator(operationsCreator);
        return this;
    }

    public ConfigurationBuilder from(Configuration template) {
        this.configuration.setThreadPoolSize(template.getThreadPoolSize());
        this.configuration.setGenerateConfigsTimeout(template.getGenerateConfigsTimeout());
        this.configuration.setModels(template.getModels());
        this.configuration.setCapabilities(template.getCapabilities());
        this.configuration.setStartingPort(template.getStartingPort());
        this.configuration.setDeviceCount(template.getDeviceCount());
        this.configuration.setSsh(template.isSsh());
        this.configuration.setIp(template.getIp());
        this.configuration.setRpcHandler(template.getRpcHandler());
        this.configuration.setOperationsCreator(template.getOperationsCreator());
        this.configuration.setMdSal(template.isMdSal());
        this.configuration.setRpcConfigFile(template.getRpcConfigFile());
        this.configuration.setInitialConfigXMLFile(template.getInitialConfigXMLFile());
        this.configuration.setNotificationFile(template.getNotificationFile());
        this.configuration.setSchemasDir(template.getSchemasDir());
        this.configuration.setDefaultYangResources(template.getDefaultYangResources());
        this.configuration.setAuthProvider(template.getAuthProvider());
        this.configuration.setPublickeyAuthenticator(template.getPublickeyAuthenticator());
        return this;
    }

    public ConfigurationBuilder from(TesttoolParameters testtoolParameters) {
        this.configuration.setGenerateConfigsTimeout(testtoolParameters.generateConfigsTimeout);
        this.configuration.setStartingPort(testtoolParameters.startingPort);
        this.configuration.setDeviceCount(testtoolParameters.deviceCount);
        this.configuration.setSsh(testtoolParameters.ssh);
        this.configuration.setIp(testtoolParameters.ip);
        this.configuration.setMdSal(testtoolParameters.mdSal);
        this.configuration.setRpcConfigFile(testtoolParameters.rpcConfig);
        this.configuration.setInitialConfigXMLFile(testtoolParameters.initialConfigXMLFile);
        this.configuration.setNotificationFile(testtoolParameters.notificationFile);
        this.configuration.setSchemasDir(testtoolParameters.schemasDir);
        this.configuration.setCapabilities(testtoolParameters.exi ? Configuration.DEFAULT_BASE_CAPABILITIES_EXI : Configuration.DEFAULT_BASE_CAPABILITIES);
        return this;
    }

    public Configuration build() {
        return this.configuration;
    }
}

