/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.config;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.test.tool.config.YangResource;
import org.opendaylight.netconf.test.tool.operations.OperationsCreator;
import org.opendaylight.netconf.test.tool.rpchandler.RpcHandler;
import org.opendaylight.netconf.test.tool.rpchandler.RpcHandlerDefault;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    public static final Set<String> DEFAULT_BASE_CAPABILITIES_EXI = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1", (Object)"urn:ietf:params:netconf:capability:exi:1.0", (Object)"urn:ietf:params:netconf:capability:notification:1.0");
    public static final Set<String> DEFAULT_BASE_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1");
    public static final Set<YangResource> DEFAULT_YANG_RESOURCES = ImmutableSet.of((Object)new YangResource("ietf-netconf-monitoring", "2010-10-04", "/META-INF/yang/ietf-netconf-monitoring@2010-10-04.yang"), (Object)new YangResource("odl-netconf-monitoring", "2022-07-18", "/META-INF/yang/odl-netconf-monitoring@2022-07-18.yang"), (Object)new YangResource("ietf-yang-types", "2013-07-15", "/META-INF/yang/ietf-yang-types@2013-07-15.yang"), (Object)new YangResource("ietf-inet-types", "2013-07-15", "/META-INF/yang/ietf-inet-types@2013-07-15.yang"));
    public static final AuthProvider DEFAULT_AUTH_PROVIDER = (username, password) -> {
        LOG.info("Auth with username and password: {}", (Object)username);
        return true;
    };
    public static final PublickeyAuthenticator DEFAULT_PUBLIC_KEY_AUTHENTICATOR = (username, key, session) -> {
        LOG.info("Auth with public key: {}", (Object)key);
        return true;
    };
    private int generateConfigsTimeout = (int)TimeUnit.MINUTES.toMillis(30L);
    private int threadPoolSize = 8;
    private int startingPort = 17830;
    private int deviceCount = 1;
    private boolean ssh = true;
    private String ip = "0.0.0.0";
    private Set<YangResource> defaultYangResources = DEFAULT_YANG_RESOURCES;
    private Set<YangModuleInfo> models;
    private Set<String> capabilities = DEFAULT_BASE_CAPABILITIES_EXI;
    private RpcHandler rpcHandler = new RpcHandlerDefault();
    private OperationsCreator operationsCreator;
    private AuthProvider authProvider = DEFAULT_AUTH_PROVIDER;
    private PublickeyAuthenticator publickeyAuthenticator = DEFAULT_PUBLIC_KEY_AUTHENTICATOR;
    @Deprecated
    private boolean mdSal = false;
    @Deprecated
    private File rpcConfigFile;
    @Deprecated
    private File notificationFile;
    @Deprecated
    private File initialConfigXMLFile;
    @Deprecated
    private File schemasDir;

    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    public Set<YangResource> getDefaultYangResources() {
        return this.defaultYangResources;
    }

    public void setDefaultYangResources(Set<YangResource> defaultYangResources) {
        this.defaultYangResources = defaultYangResources;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getStartingPort() {
        return this.startingPort;
    }

    public void setStartingPort(int startingPort) {
        this.startingPort = startingPort;
    }

    public int getDeviceCount() {
        return this.deviceCount;
    }

    public void setDeviceCount(int deviceCount) {
        this.deviceCount = deviceCount;
    }

    public int getGenerateConfigsTimeout() {
        return this.generateConfigsTimeout;
    }

    public void setGenerateConfigsTimeout(int generateConfigsTimeout) {
        this.generateConfigsTimeout = generateConfigsTimeout;
    }

    public boolean isSsh() {
        return this.ssh;
    }

    public void setSsh(boolean ssh) {
        this.ssh = ssh;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Set<YangModuleInfo> getModels() {
        return this.models;
    }

    public void setModels(Set<YangModuleInfo> models) {
        this.models = models;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Set<String> capabilities) {
        this.capabilities = capabilities;
    }

    public RpcHandler getRpcHandler() {
        return this.rpcHandler;
    }

    public void setRpcHandler(RpcHandler rpcHandler) {
        this.rpcHandler = rpcHandler;
    }

    public OperationsCreator getOperationsCreator() {
        return this.operationsCreator;
    }

    public void setOperationsCreator(OperationsCreator operationsCreator) {
        this.operationsCreator = operationsCreator;
    }

    @Deprecated
    public boolean isMdSal() {
        return this.mdSal;
    }

    @Deprecated
    public void setMdSal(boolean mdSal) {
        this.mdSal = mdSal;
    }

    @Deprecated
    public File getRpcConfigFile() {
        return this.rpcConfigFile;
    }

    @Deprecated
    public void setRpcConfigFile(File rpcConfigFile) {
        this.rpcConfigFile = rpcConfigFile;
    }

    @Deprecated
    public File getNotificationFile() {
        return this.notificationFile;
    }

    @Deprecated
    public void setNotificationFile(File notificationFile) {
        this.notificationFile = notificationFile;
    }

    @Deprecated
    public File getInitialConfigXMLFile() {
        return this.initialConfigXMLFile;
    }

    @Deprecated
    public void setInitialConfigXMLFile(File initialConfigXMLFile) {
        this.initialConfigXMLFile = initialConfigXMLFile;
    }

    @Deprecated
    public boolean isXmlConfigurationProvided() {
        return this.initialConfigXMLFile != null;
    }

    @Deprecated
    public boolean isNotificationsSupported() {
        return this.notificationFile != null;
    }

    @Deprecated
    public File getSchemasDir() {
        return this.schemasDir;
    }

    @Deprecated
    public void setSchemasDir(File schemasDir) {
        this.schemasDir = schemasDir;
    }
}

