/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.test.tool.client.stress.AbstractExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.Parameters;
import org.opendaylight.netconf.test.tool.client.stress.StressClient;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class SyncExecutionStrategy
extends AbstractExecutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SyncExecutionStrategy.class);

    SyncExecutionStrategy(Parameters params, List<NetconfMessage> preparedMessages, NetconfDeviceCommunicator sessionListener) {
        super(params, preparedMessages, sessionListener);
    }

    @Override
    public void invoke() {
        AtomicInteger responseCounter = new AtomicInteger(0);
        int batchI = 0;
        for (Integer editBatch : this.getEditBatches()) {
            for (int i = 0; i < editBatch; ++i) {
                int msgId = i + batchI * this.getParams().editBatchSize;
                NetconfMessage msg = this.getPreparedMessages().get(msgId);
                LOG.debug("Sending message {}", (Object)msgId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending message {}", (Object)XmlUtil.toString((Document)msg.getDocument()));
                }
                ListenableFuture netconfMessageFuture = this.getSessionListener().sendRequest(msg);
                this.waitForResponse(responseCounter, (ListenableFuture<RpcResult<NetconfMessage>>)netconfMessageFuture);
            }
            LOG.info("Batch {} with size {} sent. Committing", (Object)(++batchI), (Object)editBatch);
            if (!this.getParams().candidateDatastore) continue;
            this.waitForResponse(responseCounter, (ListenableFuture<RpcResult<NetconfMessage>>)this.getSessionListener().sendRequest(StressClient.COMMIT_MSG));
        }
        Preconditions.checkState((responseCounter.get() == this.getEditAmount() + (this.getParams().candidateDatastore ? this.getEditBatches().size() : 0) ? 1 : 0) != 0, (String)"Not all responses were received, only %s from %s", (int)responseCounter.get(), (int)(this.getParams().editCount + this.getEditBatches().size()));
    }

    private void waitForResponse(AtomicInteger responseCounter, ListenableFuture<RpcResult<NetconfMessage>> netconfMessageFuture) {
        try {
            RpcResult netconfMessageRpcResult = (RpcResult)netconfMessageFuture.get(this.getParams().msgTimeout, TimeUnit.SECONDS);
            if (netconfMessageRpcResult.isSuccessful()) {
                responseCounter.incrementAndGet();
                LOG.debug("Received response {}", (Object)responseCounter.get());
            } else {
                LOG.warn("Request failed {}", (Object)netconfMessageRpcResult);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IllegalStateException("Request not finished", e);
        }
    }
}

