/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfClientConfigurationBuilder;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.test.tool.client.stress.AsyncExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.ExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.Parameters;
import org.opendaylight.netconf.test.tool.client.stress.StressClient;
import org.opendaylight.netconf.test.tool.client.stress.SyncExecutionStrategy;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressClientCallable
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(StressClientCallable.class);
    private final NetconfDeviceCommunicator sessionListener;
    private final NetconfClientSession netconfClientSession;
    private final ExecutionStrategy executionStrategy;

    public StressClientCallable(Parameters params, NetconfClientFactory netconfClientFactory, NetconfClientConfiguration baseConfiguration, List<NetconfMessage> preparedMessages) {
        this.sessionListener = StressClientCallable.getSessionListener(params.getInetAddress(), params.concurrentMessageLimit);
        NetconfClientConfiguration cfg = StressClientCallable.getNetconfClientConfiguration(baseConfiguration, this.sessionListener);
        LOG.info("Connecting to netconf server {}:{}", (Object)params.ip, (Object)params.port);
        try {
            this.netconfClientSession = (NetconfClientSession)netconfClientFactory.createClient(cfg).get();
        }
        catch (InterruptedException | ExecutionException | UnsupportedConfigurationException e) {
            throw new IllegalStateException("Unable to connect", e);
        }
        this.executionStrategy = StressClientCallable.getExecutionStrategy(params, preparedMessages, this.sessionListener);
    }

    @Override
    public Boolean call() {
        this.executionStrategy.invoke();
        this.netconfClientSession.close();
        return Boolean.TRUE;
    }

    private static ExecutionStrategy getExecutionStrategy(Parameters params, List<NetconfMessage> preparedMessages, NetconfDeviceCommunicator sessionListener) {
        if (params.async) {
            return new AsyncExecutionStrategy(params, preparedMessages, sessionListener);
        }
        return new SyncExecutionStrategy(params, preparedMessages, sessionListener);
    }

    private static NetconfDeviceCommunicator getSessionListener(InetSocketAddress inetAddress, int messageLimit) {
        return new NetconfDeviceCommunicator(new RemoteDeviceId("secure-test", inetAddress), StressClient.LOGGING_REMOTE_DEVICE, messageLimit);
    }

    private static NetconfClientConfiguration getNetconfClientConfiguration(NetconfClientConfiguration base, NetconfDeviceCommunicator sessionListener) {
        return NetconfClientConfigurationBuilder.create().withProtocol(base.getProtocol()).withTcpParameters(base.getTcpParameters()).withSshParameters(base.getSshParameters()).withOdlHelloCapabilities(base.getOdlHelloCapabilities()).withAdditionalHeader((NetconfHelloMessageAdditionalHeader)base.getAdditionalHeader().orElse(null)).withConnectionTimeoutMillis(base.getConnectionTimeoutMillis().longValue()).withSessionListener((NetconfClientSessionListener)sessionListener).build();
    }
}

