/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import ch.qos.logback.classic.Level;
import com.google.common.base.Stopwatch;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.NetconfClientFactory;
import org.opendaylight.netconf.client.NetconfClientFactoryImpl;
import org.opendaylight.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.client.conf.NetconfClientConfigurationBuilder;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDevice;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.common.impl.DefaultNetconfTimer;
import org.opendaylight.netconf.test.tool.TestToolUtils;
import org.opendaylight.netconf.test.tool.client.stress.Parameters;
import org.opendaylight.netconf.test.tool.client.stress.StressClientCallable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.PasswordType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.password.grouping.password.type.CleartextPasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh.SshClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh.TcpClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.ClientIdentityBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.ssh.client.grouping.client.identity.PasswordBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class StressClient {
    private static final Logger LOG = LoggerFactory.getLogger(StressClient.class);
    static final RemoteDevice<NetconfDeviceCommunicator> LOGGING_REMOTE_DEVICE = new RemoteDevice<NetconfDeviceCommunicator>(){

        public void onRemoteSessionUp(NetconfSessionPreferences remoteSessionCapabilities, NetconfDeviceCommunicator netconfDeviceCommunicator) {
            LOG.info("Session established");
        }

        public void onRemoteSessionDown() {
            LOG.info("Session down");
        }

        public void onNotification(NetconfMessage notification) {
            LOG.info("Notification received: {}", (Object)notification);
        }
    };
    public static final NetconfMessage COMMIT_MSG = new NetconfMessage(StressClient.readString("<rpc message-id=\"commit-batch\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n    <commit/>\n</rpc>"));
    static final Document EDIT_CANDIDATE_BLUEPRINT = StressClient.readString("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n    <edit-config>\n        <target>\n            <candidate/>\n        </target>\n        <default-operation>none</default-operation>\n        <config/>\n    </edit-config>\n</rpc>");
    static final Document EDIT_RUNNING_BLUEPRINT = StressClient.readString("<rpc xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">\n    <edit-config>\n        <target>\n            <running/>\n        </target>\n        <default-operation>none</default-operation>\n        <config/>\n    </edit-config>\n</rpc>");
    private static final String MSG_ID_PLACEHOLDER_REGEX = "\\{MSG_ID\\}";
    private static final String PHYS_ADDR_PLACEHOLDER = "{PHYS_ADDR}";
    private static long macStart = 187723572641792L;
    private static Parameters params;

    private static Document readString(String str) {
        try {
            return XmlUtil.readXmlToDocument((String)str);
        }
        catch (IOException | SAXException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private StressClient() {
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException, TimeoutException {
        String editContentString;
        if (StressClient.initParameters(args)) {
            return;
        }
        params.validate();
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(StressClient.params.debug ? Level.DEBUG : Level.INFO);
        int threadAmount = StressClient.params.threadAmount;
        LOG.info("thread amount: {}", (Object)threadAmount);
        int requestsPerThread = StressClient.params.editCount / StressClient.params.threadAmount;
        LOG.info("requestsPerThread: {}", (Object)requestsPerThread);
        int leftoverRequests = StressClient.params.editCount % StressClient.params.threadAmount;
        LOG.info("leftoverRequests: {}", (Object)leftoverRequests);
        LOG.info("Preparing messages");
        ArrayList allPreparedMessages = new ArrayList(threadAmount);
        for (int i = 0; i < threadAmount; ++i) {
            if (i != threadAmount - 1) {
                allPreparedMessages.add(new ArrayList(requestsPerThread));
                continue;
            }
            allPreparedMessages.add(new ArrayList(requestsPerThread + leftoverRequests));
        }
        try {
            editContentString = Files.readString(StressClient.params.editContent.toPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read content of " + String.valueOf(StressClient.params.editContent), e);
        }
        for (int i = 0; i < threadAmount; ++i) {
            List preparedMessages = (List)allPreparedMessages.get(i);
            int padding = 0;
            if (i == threadAmount - 1) {
                padding = leftoverRequests;
            }
            for (int j = 0; j < requestsPerThread + padding; ++j) {
                LOG.debug("id: {}", (Object)(i * requestsPerThread + j));
                preparedMessages.add(StressClient.prepareMessage(i * requestsPerThread + j, editContentString));
            }
        }
        try (DefaultNetconfTimer timer = new DefaultNetconfTimer();
             NetconfClientFactoryImpl netconfClientFactory = new NetconfClientFactoryImpl((NetconfTimer)timer);){
            ArrayList<StressClientCallable> callables = new ArrayList<StressClientCallable>(threadAmount);
            for (List list : allPreparedMessages) {
                callables.add(new StressClientCallable(params, (NetconfClientFactory)netconfClientFactory, StressClient.getBaseConfiguration(), list));
            }
            ExecutorService executorService = Executors.newFixedThreadPool(threadAmount);
            LOG.info("Starting stress test");
            Stopwatch stopwatch = Stopwatch.createStarted();
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                future.get(4L, TimeUnit.MINUTES);
            }
            executorService.shutdownNow();
            stopwatch.stop();
            LOG.info("FINISHED. Execution time: {}", (Object)stopwatch);
            LOG.info("Requests per second: {}", (Object)((double)StressClient.params.editCount * 1000.0 / (double)stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
    }

    static NetconfMessage prepareMessage(int id, String editContentString) {
        Document msg = XmlUtil.createDocumentCopy((Document)(StressClient.params.candidateDatastore ? EDIT_CANDIDATE_BLUEPRINT : EDIT_RUNNING_BLUEPRINT));
        msg.getDocumentElement().setAttribute("message-id", Integer.toString(id));
        NetconfMessage netconfMessage = new NetconfMessage(msg);
        try {
            String specificEditContent = editContentString.replaceAll(MSG_ID_PLACEHOLDER_REGEX, Integer.toString(id));
            StringBuilder sb = new StringBuilder(specificEditContent);
            int idx = sb.indexOf(PHYS_ADDR_PLACEHOLDER);
            while (idx != -1) {
                sb.replace(idx, idx + PHYS_ADDR_PLACEHOLDER.length(), TestToolUtils.getMac(macStart++));
                idx = sb.indexOf(PHYS_ADDR_PLACEHOLDER);
            }
            specificEditContent = sb.toString();
            Element editContentElement = XmlUtil.readXmlToElement((String)specificEditContent);
            Node config = ((Element)msg.getDocumentElement().getElementsByTagName("edit-config").item(0)).getElementsByTagName("config").item(0);
            config.appendChild(msg.importNode(editContentElement, true));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("Edit content file is unreadable", e);
        }
        return netconfMessage;
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Exit from CLI with error without throwing an exception")
    private static boolean initParameters(String[] args) {
        ArgumentParser parser = Parameters.getParser();
        params = new Parameters();
        try {
            parser.parseArgs(args, (Object)args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
            return true;
        }
        return false;
    }

    private static NetconfClientConfiguration getBaseConfiguration() {
        NetconfClientConfigurationBuilder confBuilder = NetconfClientConfigurationBuilder.create().withProtocol(StressClient.params.ssh ? NetconfClientConfiguration.NetconfClientProtocol.SSH : NetconfClientConfiguration.NetconfClientProtocol.TCP).withConnectionTimeoutMillis(20000L).withOdlHelloCapabilities(StressClient.getCapabilities().stream().map(Uri::new).toList()).withTcpParameters((TcpClientGrouping)new TcpClientParametersBuilder().setRemoteAddress(new Host(IetfInetUtil.ipAddressFor((String)StressClient.params.ip))).setRemotePort(new PortNumber(Uint16.valueOf((int)StressClient.params.port))).build());
        if (StressClient.params.ssh) {
            confBuilder.withSshParameters((SshClientGrouping)new SshClientParametersBuilder().setClientIdentity(new ClientIdentityBuilder().setUsername(StressClient.params.username).setPassword(new PasswordBuilder().setPasswordType((PasswordType)new CleartextPasswordBuilder().setCleartextPassword(StressClient.params.password).build()).build()).build()).build());
        }
        if (StressClient.params.tcpHeader != null) {
            final String header = StressClient.params.tcpHeader.replace("\"", "").trim() + "\n";
            confBuilder.withAdditionalHeader(new NetconfHelloMessageAdditionalHeader(null, null, null, null, null){

                public String toFormattedString() {
                    LOG.debug("Sending TCP header {}", (Object)header);
                    return header;
                }
            });
        }
        return confBuilder.build();
    }

    private static Set<String> getCapabilities() {
        if (StressClient.params.exi) {
            return StressClient.params.legacyFraming ? NetconfClientSessionNegotiatorFactory.LEGACY_EXI_CLIENT_CAPABILITIES : NetconfClientSessionNegotiatorFactory.EXI_CLIENT_CAPABILITIES;
        }
        return StressClient.params.legacyFraming ? NetconfClientSessionNegotiatorFactory.LEGACY_FRAMING_CLIENT_CAPABILITIES : NetconfClientSessionNegotiatorFactory.DEFAULT_CLIENT_CAPABILITIES;
    }
}

