/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.inf.ArgumentParser;

public class Parameters {
    @Arg(dest="ip")
    public String ip;
    @Arg(dest="port")
    public int port;
    @Arg(dest="edit-count")
    public int editCount;
    @Arg(dest="edit-content")
    public File editContent;
    @Arg(dest="edit-batch-size")
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"})
    public int editBatchSize;
    @Arg(dest="candidate-datastore")
    public boolean candidateDatastore;
    @Arg(dest="debug")
    public boolean debug;
    @Arg(dest="legacy-framing")
    public boolean legacyFraming;
    @Arg(dest="exi")
    public boolean exi;
    @Arg(dest="async")
    public boolean async;
    @Arg(dest="ssh")
    public boolean ssh;
    @Arg(dest="username")
    public String username;
    @Arg(dest="password")
    public String password;
    @Arg(dest="msg-timeout")
    public long msgTimeout;
    @Arg(dest="tcp-header")
    public String tcpHeader;
    @Arg(dest="thread-amount")
    public int threadAmount;
    @Arg(dest="concurrent-message-limit")
    public int concurrentMessageLimit;

    static ArgumentParser getParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"netconf stress client");
        parser.description("Netconf stress client");
        parser.addArgument(new String[]{"--ip"}).type(String.class).setDefault((Object)"127.0.0.1").type(String.class).help("Netconf server IP").dest("ip");
        parser.addArgument(new String[]{"--port"}).type(Integer.class).setDefault((Object)2830).type(Integer.class).help("Netconf server port").dest("port");
        parser.addArgument(new String[]{"--edits"}).type(Integer.class).setDefault((Object)50000).type(Integer.class).help("Netconf edit rpcs to be sent").dest("edit-count");
        parser.addArgument(new String[]{"--edit-content"}).type(File.class).setDefault((Object)new File("edit.txt")).type(File.class).dest("edit-content");
        parser.addArgument(new String[]{"--edit-batch-size"}).type(Integer.class).required(false).setDefault((Object)-1).dest("edit-batch-size");
        parser.addArgument(new String[]{"--candidate-datastore"}).type(Boolean.class).required(false).setDefault((Object)Boolean.TRUE).help("Edit candidate or running datastore. Defaults to candidate.").dest("candidate-datastore");
        parser.addArgument(new String[]{"--debug"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).help("Whether to use debug log level instead of INFO").dest("debug");
        parser.addArgument(new String[]{"--legacy-framing"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).dest("legacy-framing");
        parser.addArgument(new String[]{"--exi"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).dest("exi");
        parser.addArgument(new String[]{"--async-requests"}).type(Boolean.class).setDefault((Object)Boolean.TRUE).dest("async");
        parser.addArgument(new String[]{"--msg-timeout"}).type(Integer.class).setDefault((Object)60).dest("msg-timeout");
        parser.addArgument(new String[]{"--ssh"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).dest("ssh");
        parser.addArgument(new String[]{"--username"}).type(String.class).setDefault((Object)"admin").dest("username");
        parser.addArgument(new String[]{"--password"}).type(String.class).setDefault((Object)"admin").dest("password");
        parser.addArgument(new String[]{"--tcp-header"}).type(String.class).required(false).dest("tcp-header");
        parser.addArgument(new String[]{"--thread-amount"}).type(Integer.class).setDefault((Object)1).dest("thread-amount");
        parser.addArgument(new String[]{"--concurrent-message-limit"}).type(Integer.class).setDefault((Object)0).help("Number of rpc messages that can be sent before receiving reply to them.").dest("concurrent-message-limit");
        return parser;
    }

    void validate() {
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0, (Object)"Port =< 0");
        Preconditions.checkArgument((this.editCount > 0 ? 1 : 0) != 0, (Object)"Edit count =< 0");
        if (this.editBatchSize == -1) {
            this.editBatchSize = this.editCount;
        } else {
            Preconditions.checkArgument((this.editBatchSize <= this.editCount ? 1 : 0) != 0, (Object)"Edit count =< 0");
        }
        Preconditions.checkArgument((boolean)this.editContent.exists(), (Object)"Edit content file missing");
        Preconditions.checkArgument((!this.editContent.isDirectory() ? 1 : 0) != 0, (Object)"Edit content file is a dir");
        Preconditions.checkArgument((boolean)this.editContent.canRead(), (Object)"Edit content file is unreadable");
        Preconditions.checkArgument((this.threadAmount > 0 ? 1 : 0) != 0, (Object)"Parameter thread-amount must be greater than 0");
        Preconditions.checkArgument((this.msgTimeout >= 0L ? 1 : 0) != 0, (Object)"Parameter msg-timeout must be greater than 0");
    }

    public InetSocketAddress getInetAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.ip), this.port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown ip", e);
        }
    }
}

