/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.test.tool.client.stress.AbstractExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.Parameters;
import org.opendaylight.netconf.test.tool.client.stress.StressClient;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class AsyncExecutionStrategy
extends AbstractExecutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncExecutionStrategy.class);

    AsyncExecutionStrategy(Parameters params, List<NetconfMessage> editConfigMsgs, NetconfDeviceCommunicator sessionListener) {
        super(params, editConfigMsgs, sessionListener);
    }

    @Override
    public void invoke() {
        AtomicInteger responseCounter = new AtomicInteger(0);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
        int batchI = 0;
        for (Integer editBatch : this.getEditBatches()) {
            for (int i = 0; i < editBatch; ++i) {
                int msgId = i + batchI * this.getParams().editBatchSize;
                NetconfMessage msg = this.getPreparedMessages().get(msgId);
                LOG.debug("Sending message {}", (Object)msgId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sending message {}", (Object)XmlUtil.toString((Document)msg.getDocument()));
                }
                ListenableFuture netconfMessageFuture = this.getSessionListener().sendRequest(msg);
                futures.add(netconfMessageFuture);
            }
            LOG.info("Batch {} with size {} sent. Committing", (Object)(++batchI), (Object)editBatch);
            if (!this.getParams().candidateDatastore) continue;
            futures.add(this.getSessionListener().sendRequest(StressClient.COMMIT_MSG));
        }
        LOG.info("All batches sent. Waiting for responses");
        for (ListenableFuture future : futures) {
            try {
                RpcResult netconfMessageRpcResult = (RpcResult)future.get(this.getParams().msgTimeout, TimeUnit.SECONDS);
                if (netconfMessageRpcResult.isSuccessful()) {
                    responseCounter.incrementAndGet();
                    LOG.debug("Received response {}", (Object)responseCounter.get());
                    continue;
                }
                LOG.warn("Request failed {}", (Object)netconfMessageRpcResult);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Request not finished", e);
            }
        }
        Preconditions.checkState((responseCounter.get() == this.getEditAmount() + (this.getParams().candidateDatastore ? this.getEditBatches().size() : 0) ? 1 : 0) != 0, (String)"Not all responses were received, only %s from %s", (int)responseCounter.get(), (int)(this.getParams().editCount + this.getEditBatches().size()));
    }
}

