/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.stress;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.test.tool.client.stress.ExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.Parameters;

abstract class AbstractExecutionStrategy
implements ExecutionStrategy {
    private final Parameters params;
    private final List<NetconfMessage> preparedMessages;
    private final NetconfDeviceCommunicator sessionListener;
    private final List<Integer> editBatches;
    private final int editAmount;

    AbstractExecutionStrategy(Parameters params, List<NetconfMessage> editConfigMsgs, NetconfDeviceCommunicator sessionListener) {
        this.editAmount = editConfigMsgs.size();
        this.params = params;
        this.preparedMessages = editConfigMsgs;
        this.sessionListener = sessionListener;
        this.editBatches = AbstractExecutionStrategy.countEditBatchSizes(params.editBatchSize, this.editAmount);
    }

    private static List<Integer> countEditBatchSizes(int editBatchSize, int amount) {
        ArrayList<Integer> editBatches = new ArrayList<Integer>();
        if (editBatchSize != amount) {
            int fullBatches = amount / editBatchSize;
            for (int i = 0; i < fullBatches; ++i) {
                editBatches.add(editBatchSize);
            }
            int remainder = amount % editBatchSize;
            if (remainder != 0) {
                editBatches.add(remainder);
            }
        } else {
            editBatches.add(editBatchSize);
        }
        return editBatches;
    }

    protected Parameters getParams() {
        return this.params;
    }

    protected List<NetconfMessage> getPreparedMessages() {
        return this.preparedMessages;
    }

    protected NetconfDeviceCommunicator getSessionListener() {
        return this.sessionListener;
    }

    protected List<Integer> getEditBatches() {
        return this.editBatches;
    }

    protected int getEditAmount() {
        return this.editAmount;
    }
}

