/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.http.perf;

import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.List;
import org.opendaylight.netconf.test.tool.client.http.perf.RequestMessageUtils;
import org.opendaylight.netconf.test.tool.client.http.perf.RestPerfClient;
import org.opendaylight.netconf.test.tool.client.stress.ExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncExecutionStrategy
implements ExecutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SyncExecutionStrategy.class);
    private static final List<Integer> ACCEPTED_CODES = List.of(Integer.valueOf(200), Integer.valueOf(201), Integer.valueOf(204));
    private final HttpClient httpClient;
    private final RestPerfClient.RequestData payloads;

    SyncExecutionStrategy(HttpClient httpClient, RestPerfClient.RequestData payloads) {
        this.httpClient = httpClient;
        this.payloads = payloads;
    }

    @Override
    public void invoke() {
        LOG.info("Begin sending sync requests");
        for (int i = 0; i < this.payloads.getRequests(); ++i) {
            HttpResponse<String> response;
            String message = RequestMessageUtils.prepareMessage(this.payloads.getThreadId(), i, this.payloads.getContentString(), this.payloads.getPort());
            try {
                response = this.httpClient.send(RequestMessageUtils.formRequest(this.payloads.getDestination(), message), HttpResponse.BodyHandlers.ofString());
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Failed to execute request", (Throwable)e);
                return;
            }
            if (ACCEPTED_CODES.contains(response.statusCode())) continue;
            LOG.warn("Status code: {}", (Object)response.statusCode());
            LOG.warn("url: {}", (Object)response.uri());
            LOG.warn("body: {}", (Object)response.body());
        }
        LOG.info("End sending sync requests");
    }
}

