/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.http.perf;

import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.opendaylight.netconf.test.tool.client.http.perf.Parameters;
import org.opendaylight.netconf.test.tool.client.http.perf.PerfClientCallable;
import org.opendaylight.netconf.test.tool.client.http.perf.RequestMessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT"})
public final class RestPerfClient {
    private static final Logger LOG = LoggerFactory.getLogger(RestPerfClient.class);
    static int throttle;

    private RestPerfClient() {
    }

    public static void main(String[] args) {
        String editContentString;
        Parameters parameters = RestPerfClient.parseArgs(args, Parameters.getParser());
        parameters.validate();
        throttle = parameters.throttle / parameters.threadAmount;
        if (parameters.async && parameters.threadAmount > 1) {
            LOG.info("Throttling per thread: {}", (Object)throttle);
        }
        try {
            editContentString = Files.asCharSource((File)parameters.editContent, (Charset)StandardCharsets.UTF_8).read();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read content of " + String.valueOf(parameters.editContent), e);
        }
        int threadAmount = parameters.threadAmount;
        LOG.info("thread amount: {}", (Object)threadAmount);
        int requestsPerThread = parameters.editCount / parameters.threadAmount;
        LOG.info("requestsPerThread: {}", (Object)requestsPerThread);
        int leftoverRequests = parameters.editCount % parameters.threadAmount;
        LOG.info("leftoverRequests: {}", (Object)leftoverRequests);
        ArrayList<RequestData> allThreadsPayloads = new ArrayList<RequestData>();
        for (int i = 0; i < threadAmount; ++i) {
            int numberOfReq = requestsPerThread;
            if (i == threadAmount - 1) {
                numberOfReq += leftoverRequests;
            }
            RequestData payload = RequestMessageUtils.formPayload(parameters, editContentString, i, numberOfReq);
            allThreadsPayloads.add(payload);
        }
        ArrayList<PerfClientCallable> callables = new ArrayList<PerfClientCallable>();
        for (RequestData payload : allThreadsPayloads) {
            callables.add(new PerfClientCallable(parameters, payload));
        }
        ExecutorService executorService = Executors.newFixedThreadPool(threadAmount);
        LOG.info("Starting performance test");
        boolean allThreadsCompleted = true;
        Stopwatch started = Stopwatch.createStarted();
        try {
            List futures = executorService.invokeAll(callables, parameters.timeout, TimeUnit.MINUTES);
            for (int i = 0; i < futures.size(); ++i) {
                Future future = futures.get(i);
                if (future.isCancelled()) {
                    allThreadsCompleted = false;
                    LOG.info("{}. thread timed out.", (Object)(i + 1));
                    continue;
                }
                try {
                    future.get();
                    continue;
                }
                catch (ExecutionException e) {
                    allThreadsCompleted = false;
                    LOG.info("{}. thread failed.", (Object)(i + 1), (Object)e);
                }
            }
        }
        catch (InterruptedException e) {
            allThreadsCompleted = false;
            LOG.warn("Unable to execute requests", (Throwable)e);
        }
        executorService.shutdownNow();
        started.stop();
        LOG.info("FINISHED. Execution time: {}", (Object)started);
        if (allThreadsCompleted) {
            LOG.info("Requests per second: {}", (Object)((double)parameters.editCount * 1000.0 / (double)started.elapsed(TimeUnit.MILLISECONDS)));
        }
        System.exit(0);
    }

    private static Parameters parseArgs(String[] args, ArgumentParser parser) {
        Parameters opt = new Parameters();
        try {
            parser.parseArgs(args, (Object)opt);
            return opt;
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
            return null;
        }
    }

    static final class RequestData {
        private final String destination;
        private final String contentString;
        private final int threadId;
        private final int port;
        private final int requests;

        RequestData(String destination, String contentString, int threadId, int port, int requests) {
            this.destination = destination;
            this.contentString = contentString;
            this.threadId = threadId;
            this.port = port;
            this.requests = requests;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getContentString() {
            return this.contentString;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public int getPort() {
            return this.port;
        }

        public int getRequests() {
            return this.requests;
        }
    }
}

