/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.http.perf;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.util.concurrent.Callable;
import org.opendaylight.netconf.test.tool.client.http.perf.AsyncExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.http.perf.Parameters;
import org.opendaylight.netconf.test.tool.client.http.perf.RestPerfClient;
import org.opendaylight.netconf.test.tool.client.http.perf.SyncExecutionStrategy;
import org.opendaylight.netconf.test.tool.client.stress.ExecutionStrategy;

public class PerfClientCallable
implements Callable<Void> {
    private final ExecutionStrategy executionStrategy;

    public PerfClientCallable(final Parameters params, RestPerfClient.RequestData payloads) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (params.auth != null) {
            builder.authenticator(new Authenticator(this){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(params.auth.get(0), params.auth.get(1).toCharArray());
                }
            });
        }
        this.executionStrategy = params.async ? new AsyncExecutionStrategy(params, builder.build(), payloads) : new SyncExecutionStrategy(builder.build(), payloads);
    }

    @Override
    public Void call() {
        this.executionStrategy.invoke();
        return null;
    }
}

