/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.http.perf;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.inf.ArgumentParser;

public class Parameters {
    @Arg(dest="ip")
    public String ip;
    @Arg(dest="port")
    public int port;
    @Arg(dest="destination")
    public String destination;
    @Arg(dest="edit-count")
    public int editCount;
    @Arg(dest="edit-content")
    public File editContent;
    @Arg(dest="async")
    public boolean async;
    @Arg(dest="thread-amount")
    public int threadAmount;
    @Arg(dest="same-device")
    public boolean sameDevice;
    @Arg(dest="device-port-range-start")
    public int devicePortRangeStart;
    @Arg(dest="throttle")
    public int throttle;
    @Arg(dest="auth")
    public List<String> auth;
    @Arg(dest="timeout")
    public long timeout;

    static ArgumentParser getParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"netconf stress client");
        parser.description("Netconf stress client");
        parser.addArgument(new String[]{"--ip"}).type(String.class).setDefault((Object)"127.0.0.1").help("Restconf server IP").dest("ip");
        parser.addArgument(new String[]{"--port"}).type(Integer.class).setDefault((Object)8181).help("Restconf server port").dest("port");
        parser.addArgument(new String[]{"--destination"}).type(String.class).setDefault((Object)"/rests/data/network-topology:network-topology/topology=topology-netconf/node={DEVICE_PORT}-sim-device/yang-ext:mount/cisco-vpp:vpp/bridge-domains=bridge-domain/a").help("Destination to send the requests to after the ip:port part of the uri. Use {DEVICE_PORT} tag to use the device-port-range-start argument").dest("destination");
        parser.addArgument(new String[]{"--edits"}).type(Integer.class).setDefault((Object)50000).help("Amount requests to be sent").dest("edit-count");
        parser.addArgument(new String[]{"--edit-content"}).type(File.class).setDefault((Object)new File("edit.txt")).dest("edit-content");
        parser.addArgument(new String[]{"--async-requests"}).type(Boolean.class).setDefault((Object)Boolean.TRUE).dest("async");
        parser.addArgument(new String[]{"--thread-amount"}).type(Integer.class).setDefault((Object)1).dest("thread-amount");
        parser.addArgument(new String[]{"--same-device"}).type(Boolean.class).setDefault((Object)Boolean.TRUE).help("If true, every thread edits the device at the first port. If false, n-th thread edits device at n-th port.").dest("same-device");
        parser.addArgument(new String[]{"--device-port-range-start"}).type(Integer.class).setDefault((Object)17830).dest("device-port-range-start");
        parser.addArgument(new String[]{"--throttle"}).type(Integer.class).setDefault((Object)5000).help("Maximum amount of async requests that can be open at a time, with mutltiple threads this gets divided among all threads").dest("throttle");
        parser.addArgument(new String[]{"--auth"}).setDefault((Object[])new String[]{"admin", "admin"}).nargs(2).help("Username and password for HTTP basic authentication in order username password.").dest("auth");
        parser.addArgument(new String[]{"--timeout"}).type(Long.class).setDefault((Object)5).help("Maximum time in minutes to wait for finishing all requests.").dest("timeout");
        return parser;
    }

    void validate() {
        Preconditions.checkArgument((this.port > 0 ? 1 : 0) != 0, (Object)"Port =< 0");
        Preconditions.checkArgument((this.editCount > 0 ? 1 : 0) != 0, (Object)"Edit count =< 0");
        Preconditions.checkArgument((this.timeout > 0L ? 1 : 0) != 0, (Object)"Timeout =< 0");
        Preconditions.checkArgument((boolean)this.editContent.exists(), (Object)"Edit content file missing");
        Preconditions.checkArgument((!this.editContent.isDirectory() ? 1 : 0) != 0, (Object)"Edit content file is a dir");
        Preconditions.checkArgument((boolean)this.editContent.canRead(), (Object)"Edit content file is unreadable");
        Preconditions.checkArgument((boolean)this.destination.startsWith("/"), (Object)"Destination should start with a '/'");
        Preconditions.checkArgument((this.threadAmount > 0 ? 1 : 0) != 0, (Object)"Parameter thread-amount must be greater than 0");
    }

    public InetSocketAddress getInetAddress() {
        try {
            return new InetSocketAddress(InetAddress.getByName(this.ip), this.port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown ip", e);
        }
    }
}

