/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool.client.http.perf;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.Semaphore;
import org.opendaylight.netconf.test.tool.client.http.perf.Parameters;
import org.opendaylight.netconf.test.tool.client.http.perf.RequestMessageUtils;
import org.opendaylight.netconf.test.tool.client.http.perf.RestPerfClient;
import org.opendaylight.netconf.test.tool.client.stress.ExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutionStrategy
implements ExecutionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncExecutionStrategy.class);
    private final HttpClient httpClient;
    private final Parameters params;
    private final Semaphore semaphore;
    RestPerfClient.RequestData payloads;

    AsyncExecutionStrategy(Parameters params, HttpClient httpClient, RestPerfClient.RequestData payloads) {
        this.params = params;
        this.httpClient = httpClient;
        this.payloads = payloads;
        this.semaphore = new Semaphore(RestPerfClient.throttle);
    }

    @Override
    public void invoke() {
        LOG.info("Begin sending async requests");
        for (int i = 0; i < this.payloads.getRequests(); ++i) {
            String message = RequestMessageUtils.prepareMessage(this.payloads.getThreadId(), i, this.payloads.getContentString(), this.payloads.getPort());
            String url = this.payloads.getDestination();
            HttpRequest request = RequestMessageUtils.formRequest(url, message);
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                LOG.warn("Semaphore acquire interrupted");
            }
            this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).whenComplete((response, error) -> {
                switch (response.statusCode()) {
                    case 200: 
                    case 204: {
                        break;
                    }
                    default: {
                        LOG.warn("Request failed, status code: {}", (Object)response.statusCode());
                        LOG.warn("request: {}", (Object)request);
                    }
                }
                this.semaphore.release();
            });
        }
        LOG.info("Requests sent, waiting for responses");
        try {
            this.semaphore.acquire(RestPerfClient.throttle);
        }
        catch (InterruptedException e) {
            LOG.warn("Semaphore acquire interrupted");
        }
        LOG.info("Responses received, ending...");
    }
}

