/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import org.opendaylight.netconf.shaded.sshd.common.cipher.ECCurves;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProvider;
import org.opendaylight.netconf.shaded.sshd.common.session.SessionContext;
import org.opendaylight.netconf.shaded.sshd.common.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualKeyPairProvider
implements KeyPairProvider {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualKeyPairProvider.class);
    private KeyPair generatedKeyPair;
    private String algorithm = "RSA";
    private AlgorithmParameterSpec keySpecification;
    private Integer keySize;

    VirtualKeyPairProvider() {
    }

    VirtualKeyPairProvider(String algorithm, AlgorithmParameterSpec keySpecification, Integer keySize) {
        this.algorithm = algorithm;
        this.keySpecification = keySpecification;
        this.keySize = keySize;
    }

    public synchronized Iterable<KeyPair> loadKeys(SessionContext session) {
        if (this.generatedKeyPair == null) {
            try {
                this.generatedKeyPair = this.generateKeyPair();
            }
            catch (GeneralSecurityException e) {
                LOG.error("Cannot generate key with algorithm '{}', key specification '{}', and key size '{}'.", new Object[]{this.algorithm, this.keySpecification, this.keySize, e});
                throw new IllegalArgumentException("An error occurred during generation of a new ke pair.", e);
            }
        }
        return Collections.singleton(this.generatedKeyPair);
    }

    private KeyPair generateKeyPair() throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator((String)this.algorithm);
        if (this.keySpecification != null) {
            generator.initialize(this.keySpecification);
        } else if (this.keySize != null) {
            generator.initialize(this.keySize);
        } else if ("EC".equals(this.algorithm)) {
            int numCurves = ECCurves.SORTED_KEY_SIZE.size();
            ECCurves curve = (ECCurves)ECCurves.SORTED_KEY_SIZE.get(numCurves - 1);
            generator.initialize(curve.getParameters());
        }
        return generator.generateKeyPair();
    }
}

