/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.annotation.Arg;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;

@SuppressFBWarnings(value={"DM_EXIT"})
public final class TesttoolParameters {
    @Arg(dest="async")
    public boolean async;
    @Arg(dest="thread-amount")
    public int threadAmount;
    @Arg(dest="throttle")
    public int throttle;
    @Arg(dest="controller-auth-username")
    public String controllerAuthUsername;
    @Arg(dest="controller-auth-password")
    public String controllerAuthPassword;
    @Arg(dest="controller-ip")
    public String controllerIp;
    @Arg(dest="controller-port")
    public Integer controllerPort;
    @Arg(dest="schemas-dir")
    public File schemasDir;
    @Arg(dest="devices-count")
    public int deviceCount;
    @Arg(dest="devices-per-port")
    public int devicesPerPort;
    @Arg(dest="starting-port")
    public int startingPort;
    @Arg(dest="generate-config-connection-timeout")
    public int generateConfigsTimeout;
    @Arg(dest="generate-config-address")
    public String generateConfigsAddress;
    @Arg(dest="distro-folder")
    public File distroFolder;
    @Arg(dest="generate-configs-batch-size")
    public int generateConfigBatchSize;
    @Arg(dest="ssh")
    public boolean ssh;
    @Arg(dest="exi")
    public boolean exi = true;
    @Arg(dest="debug")
    public boolean debug;
    @Arg(dest="notification-file")
    public File notificationFile;
    @Arg(dest="md-sal")
    public boolean mdSal;
    @Arg(dest="initial-config-xml-file")
    public File initialConfigXMLFile;
    @Arg(dest="time-out")
    public long timeOut;
    @Arg(dest="ip")
    public String ip;
    @Arg(dest="thread-pool-size")
    public int threadPoolSize;
    @Arg(dest="rpc-config")
    public File rpcConfig;

    static ArgumentParser getParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"netconf testtool").defaultHelp(true);
        parser.description("netconf testtool");
        parser.addArgument(new String[]{"--edit-content"}).type(String.class).dest("edit-content");
        parser.addArgument(new String[]{"--async-requests"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).dest("async");
        parser.addArgument(new String[]{"--thread-amount"}).type(Integer.class).setDefault((Object)1).dest("thread-amount").help("The number of threads to use for configuring devices.");
        parser.addArgument(new String[]{"--throttle"}).type(Integer.class).setDefault((Object)5000).help("Maximum amount of async requests that can be open at a time, with mutltiple threads this gets divided among all threads").dest("throttle");
        parser.addArgument(new String[]{"--controller-auth-username"}).type(String.class).setDefault((Object)"admin").help("Username for HTTP basic authentication to destination controller.").dest("controller-auth-username");
        parser.addArgument(new String[]{"--controller-auth-password"}).type(String.class).setDefault((Object)"admin").help("Password for HTTP basic authentication to destination controller.").dest("controller-auth-password");
        parser.addArgument(new String[]{"--controller-ip"}).type(String.class).help("Ip of controller if available it will be used for spawning netconf connectors via topology configuration as a part of URI(http://<controller-ip>:<controller-port>/rests/data/...) otherwise it will just start simulated devices and skip the execution of PATCH requests").dest("controller-ip");
        parser.addArgument(new String[]{"--controller-port"}).type(Integer.class).help("Port of controller if available it will be used for spawning netconf connectors via topology configuration as a part of URI(http://<controller-ip>:<controller-port>/rests/data/...) otherwise it will just start simulated devices and skip the execution of PATCH requests").dest("controller-port");
        parser.addArgument(new String[]{"--device-count"}).type(Integer.class).setDefault((Object)1).help("Number of simulated netconf devices to spin. This is the number of actual ports open for the devices.").dest("devices-count");
        parser.addArgument(new String[]{"--devices-per-port"}).type(Integer.class).setDefault((Object)1).help("Amount of config files generated per port to spoof more devices than are actually running").dest("devices-per-port");
        parser.addArgument(new String[]{"--schemas-dir"}).type(File.class).help("Directory containing yang schemas to describe simulated devices. Some schemas e.g. netconf monitoring and inet types are included by default").dest("schemas-dir");
        parser.addArgument(new String[]{"--notification-file"}).type(File.class).help("Xml file containing notifications that should be sent to clients after create subscription is called").dest("notification-file");
        parser.addArgument(new String[]{"--initial-config-xml-file"}).type(File.class).help("Xml file containing initial simulatted configuration to be returned via get-config rpc").dest("initial-config-xml-file");
        parser.addArgument(new String[]{"--starting-port"}).type(Integer.class).setDefault((Object)17830).help("First port for simulated device. Each other device will have previous+1 port number").dest("starting-port");
        parser.addArgument(new String[]{"--generate-config-connection-timeout"}).type(Integer.class).setDefault((Object)((int)TimeUnit.MINUTES.toMillis(30L))).help("Timeout to be generated in initial config files").dest("generate-config-connection-timeout");
        parser.addArgument(new String[]{"--generate-config-address"}).type(String.class).setDefault((Object)"127.0.0.1").help("Address to be placed in generated configs").dest("generate-config-address");
        parser.addArgument(new String[]{"--generate-configs-batch-size"}).type(Integer.class).setDefault((Object)1).help("Number of connector configs per generated file").dest("generate-configs-batch-size");
        parser.addArgument(new String[]{"--distribution-folder"}).type(File.class).help("Directory where the karaf distribution for controller is located").dest("distro-folder");
        parser.addArgument(new String[]{"--ssh"}).type(Boolean.class).setDefault((Object)Boolean.TRUE).help("Whether to use ssh for transport or just pure tcp").dest("ssh");
        parser.addArgument(new String[]{"--exi"}).type(Boolean.class).setDefault((Object)Boolean.TRUE).help("Whether to use exi to transport xml content").dest("exi");
        parser.addArgument(new String[]{"--debug"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).help("Whether to use debug log level instead of INFO").dest("debug");
        parser.addArgument(new String[]{"--md-sal"}).type(Boolean.class).setDefault((Object)Boolean.FALSE).help("Whether to use md-sal datastore instead of default simulated datastore.").dest("md-sal");
        parser.addArgument(new String[]{"--time-out"}).type(Long.TYPE).setDefault((Object)20).help("the maximum time in seconds for executing each PATCH request").dest("time-out");
        parser.addArgument(new String[]{"--ip"}).type(String.class).setDefault((Object)"0.0.0.0").help("Ip address which will be used for creating a socket address.It can either be a machine name, such as java.sun.com, or a textual representation of its IP address.").dest("ip");
        parser.addArgument(new String[]{"--thread-pool-size"}).type(Integer.class).setDefault((Object)8).help("The number of threads to keep in the pool, when creating a device simulator. Even if they are idle.").dest("thread-pool-size");
        parser.addArgument(new String[]{"--rpc-config"}).type(File.class).help("Rpc config file. It can be used to define custom rpc behavior, or override the default one.Usable for testing buggy device behavior.").dest("rpc-config");
        return parser;
    }

    static TesttoolParameters parseArgs(String[] args, ArgumentParser parser) {
        TesttoolParameters opt = new TesttoolParameters();
        try {
            parser.parseArgs(args, (Object)opt);
            return opt;
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
            return null;
        }
    }

    void validate() {
        if (this.controllerIp != null) {
            Preconditions.checkArgument((this.controllerPort != null ? 1 : 0) != 0, (Object)"Controller port is missing");
            Preconditions.checkArgument((this.controllerPort >= 0 ? 1 : 0) != 0, (Object)"Controller port should be non-negative integer");
            Preconditions.checkArgument((this.controllerPort < 65354 ? 1 : 0) != 0, (Object)"Controller port should be less than 65354");
        } else {
            Preconditions.checkArgument((this.controllerPort == null ? 1 : 0) != 0, (Object)"Controller ip is missing");
        }
        Preconditions.checkArgument((this.deviceCount > 0 ? 1 : 0) != 0, (Object)"Device count has to be > 0");
        Preconditions.checkArgument((this.startingPort > 1023 ? 1 : 0) != 0, (Object)"Starting port has to be > 1023");
        Preconditions.checkArgument((this.devicesPerPort > 0 ? 1 : 0) != 0, (Object)"At least one device per port needed");
        if (this.schemasDir != null) {
            Preconditions.checkArgument((boolean)this.schemasDir.exists(), (Object)"Schemas dir has to exist");
            Preconditions.checkArgument((boolean)this.schemasDir.isDirectory(), (Object)"Schemas dir has to be a directory");
            Preconditions.checkArgument((boolean)this.schemasDir.canRead(), (Object)"Schemas dir has to be readable");
            File[] filesArray = this.schemasDir.listFiles();
            if (filesArray != null) {
                for (File file : filesArray) {
                    Preconditions.checkArgument((boolean)file.canRead(), (Object)"Files in schemas dir has to be readable");
                    Preconditions.checkArgument((boolean)file.getName().endsWith(".yang"), (Object)"Files in schemas dir has to be YANG files");
                }
            }
        }
        if (this.rpcConfig != null) {
            Preconditions.checkArgument((boolean)this.rpcConfig.exists(), (Object)"Rpc config file has to exist");
            Preconditions.checkArgument((!this.rpcConfig.isDirectory() ? 1 : 0) != 0, (Object)"Rpc config file can't be a directory");
            Preconditions.checkArgument((boolean)this.rpcConfig.canRead(), (Object)"Rpc config file to be readable");
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", \n", "TesttoolParameters{", "}\n");
        Arrays.stream(this.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(Arg.class) != null).map(this::getFieldString).forEach(joiner::add);
        return joiner.toString();
    }

    private String getFieldString(Field field) {
        try {
            return field.getName() + "='" + String.valueOf(field.get(this)) + "'";
        }
        catch (IllegalAccessException e) {
            return field.getName() + "= UNKNOWN";
        }
    }
}

