/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.server.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.netconf.server.api.SessionIdProvider;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TesttoolNegotiationFactory
extends NetconfServerSessionNegotiatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TesttoolNegotiationFactory.class);
    private final ConcurrentMap<SocketAddress, NetconfOperationService> operationServices = new ConcurrentHashMap<SocketAddress, NetconfOperationService>();

    public TesttoolNegotiationFactory(NetconfTimer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService) {
        super(timer, netconfOperationProvider, idProvider, connectionTimeoutMillis, monitoringService, (Set)NetconfServerSessionNegotiatorFactory.DEFAULT_BASE_CAPABILITIES);
    }

    public TesttoolNegotiationFactory(NetconfTimer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService, Set<String> baseCapabilities) {
        super(timer, netconfOperationProvider, idProvider, connectionTimeoutMillis, monitoringService, baseCapabilities);
    }

    protected NetconfOperationService getOperationServiceForAddress(SessionIdType sessionId, SocketAddress socketAddress) {
        return this.operationServices.computeIfAbsent(socketAddress, addr -> {
            LOG.debug("Session {}: Creating new operation service factory for test tool device on address {}", (Object)sessionId.getValue(), addr);
            return this.getOperationServiceFactory().createService(sessionId);
        });
    }
}

