/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.test.tool.rpc.DataList;
import org.opendaylight.netconf.test.tool.rpc.SimulatedCommit;
import org.opendaylight.netconf.test.tool.rpc.SimulatedCreateSubscription;
import org.opendaylight.netconf.test.tool.rpc.SimulatedDiscardChanges;
import org.opendaylight.netconf.test.tool.rpc.SimulatedEditConfig;
import org.opendaylight.netconf.test.tool.rpc.SimulatedGet;
import org.opendaylight.netconf.test.tool.rpc.SimulatedGetConfig;
import org.opendaylight.netconf.test.tool.rpc.SimulatedLock;
import org.opendaylight.netconf.test.tool.rpc.SimulatedUnLock;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.concepts.Registration;

class SimulatedOperationProvider
implements NetconfOperationServiceFactory {
    private final @NonNull Set<Capability> caps;
    private final Optional<File> notificationsFile;
    private final Optional<File> initialConfigXMLFile;

    SimulatedOperationProvider(Set<Capability> caps, Optional<File> notificationsFile, Optional<File> initialConfigXMLFile) {
        this.caps = Objects.requireNonNull(caps);
        this.notificationsFile = notificationsFile;
        this.initialConfigXMLFile = initialConfigXMLFile;
    }

    public Set<Capability> getCapabilities() {
        return this.caps;
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(this.caps, Set.of());
        return () -> {};
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return new SimulatedOperationService(sessionId, this.notificationsFile, this.initialConfigXMLFile);
    }

    static class SimulatedOperationService
    implements NetconfOperationService {
        private final SessionIdType currentSessionId;
        private final Optional<File> notificationsFile;
        private final Optional<File> initialConfigXMLFile;

        SimulatedOperationService(SessionIdType currentSessionId, Optional<File> notificationsFile, Optional<File> initialConfigXMLFile) {
            this.currentSessionId = Objects.requireNonNull(currentSessionId);
            this.notificationsFile = notificationsFile;
            this.initialConfigXMLFile = initialConfigXMLFile;
        }

        public Set<NetconfOperation> getNetconfOperations() {
            DataList storage = new DataList();
            SimulatedGet sGet = new SimulatedGet(this.currentSessionId, storage);
            SimulatedEditConfig sEditConfig = new SimulatedEditConfig(this.currentSessionId, storage);
            SimulatedGetConfig sGetConfig = new SimulatedGetConfig(this.currentSessionId, storage, this.initialConfigXMLFile);
            SimulatedCommit sCommit = new SimulatedCommit(this.currentSessionId);
            SimulatedLock sLock = new SimulatedLock(this.currentSessionId);
            SimulatedUnLock sUnlock = new SimulatedUnLock(this.currentSessionId);
            SimulatedCreateSubscription sCreateSubs = new SimulatedCreateSubscription(this.currentSessionId, this.notificationsFile);
            SimulatedDiscardChanges sDiscardChanges = new SimulatedDiscardChanges(this.currentSessionId);
            return Sets.newHashSet((Object[])new NetconfOperation[]{sGet, sGetConfig, sEditConfig, sCommit, sLock, sUnlock, sCreateSubs, sDiscardChanges});
        }

        public void close() {
        }
    }
}

