/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import ch.qos.logback.classic.Level;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.netconf.test.tool.Execution;
import org.opendaylight.netconf.test.tool.NetconfDeviceSimulator;
import org.opendaylight.netconf.test.tool.TesttoolParameters;
import org.opendaylight.netconf.test.tool.config.Configuration;
import org.opendaylight.netconf.test.tool.config.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_EXIT", "DM_DEFAULT_ENCODING", "SLF4J_LOGGER_SHOULD_BE_FINAL"})
public final class ScaleUtil {
    private static final ScheduledExecutorService EXECUTOR = new LoggingWrapperExecutor(4);
    private static final Semaphore SEMAPHORE = new Semaphore(0);
    private static final Stopwatch STOPWATCH = Stopwatch.createUnstarted();
    private static final String RESTCONF_URL = "http://%s:%d/rests/data/network-topology:network-topology?content=nonconfig";
    private static final long TIMEOUT = 20L;
    private static final long RETRY_DELAY = 10L;
    private static final int DEVICE_STEP = 1000;
    private static ch.qos.logback.classic.Logger root;
    private static Logger resultsLog;

    private ScaleUtil() {
    }

    public static void main(String[] args) {
        TesttoolParameters params = TesttoolParameters.parseArgs(args, TesttoolParameters.getParser());
        ScaleUtil.setUpLoggers(params);
        Runtime runtime = Runtime.getRuntime();
        ScaleUtil.cleanup(runtime, params);
        while (true) {
            root.warn("Starting scale test with {} devices", (Object)params.deviceCount);
            ScheduledFuture<Void> timeoutGuardFuture = EXECUTOR.schedule(new TimeoutGuard(), 20L, TimeUnit.MINUTES);
            Configuration configuration = new ConfigurationBuilder().from(params).build();
            NetconfDeviceSimulator netconfDeviceSimulator = new NetconfDeviceSimulator(configuration);
            List<Integer> openDevices = netconfDeviceSimulator.start();
            if (openDevices.size() == 0) {
                root.error("Failed to start any simulated devices, exiting...");
                System.exit(1);
            }
            if (params.distroFolder == null) {
                root.error("Distro folder is not set, exiting...");
                System.exit(1);
            }
            root.warn(params.distroFolder.getAbsolutePath());
            try {
                String status;
                runtime.exec(params.distroFolder.getAbsolutePath() + "/bin/start");
                do {
                    Process list = runtime.exec(params.distroFolder.getAbsolutePath() + "/bin/client feature:list");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        root.warn("Failed to sleep", (Throwable)e);
                    }
                    status = CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(list.getErrorStream())));
                    root.warn(status);
                } while (status.startsWith("Failed to get the session"));
                root.warn("Doing feature install {}", (Object)(params.distroFolder.getAbsolutePath() + "/bin/client feature:install odl-restconf-nb odl-netconf-topology"));
                Process featureInstall = runtime.exec(params.distroFolder.getAbsolutePath() + "/bin/client feature:install odl-restconf-nb odl-netconf-topology");
                root.warn(CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(featureInstall.getInputStream()))));
                root.warn(CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(featureInstall.getErrorStream()))));
            }
            catch (IOException e) {
                root.error("Failed to start karaf", (Throwable)e);
                System.exit(1);
            }
            ScaleUtil.waitNetconfTopologyReady(params);
            Execution ex = new Execution(openDevices, params);
            ex.call();
            root.warn("Karaf started, starting stopwatch");
            STOPWATCH.start();
            try {
                EXECUTOR.schedule(new ScaleVerifyCallable(params), 10L, TimeUnit.SECONDS);
                root.warn("First callable scheduled");
                SEMAPHORE.acquire();
                root.warn("semaphore released");
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for semaphore", e);
            }
            timeoutGuardFuture.cancel(false);
            params.deviceCount += 1000;
            netconfDeviceSimulator.close();
            STOPWATCH.reset();
            ScaleUtil.cleanup(runtime, params);
        }
    }

    private static void setUpLoggers(TesttoolParameters params) {
        System.setProperty("log_file_name", "scale-util.log");
        root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(params.debug ? Level.DEBUG : Level.INFO);
        resultsLog = LoggerFactory.getLogger((String)"results");
    }

    private static void cleanup(Runtime runtime, TesttoolParameters params) {
        try {
            ScaleUtil.stopKaraf(runtime, params);
            ScaleUtil.deleteFolder(new File(String.valueOf(params.distroFolder.getAbsoluteFile()) + "/data"));
        }
        catch (IOException | InterruptedException e) {
            root.warn("Failed to stop karaf", (Throwable)e);
            System.exit(1);
        }
    }

    private static void stopKaraf(Runtime runtime, TesttoolParameters params) throws IOException, InterruptedException {
        root.info("Stopping karaf and sleeping for 10 sec..");
        String controllerPid = "";
        do {
            Process pgrep = runtime.exec("pgrep -f org.apache.karaf.main.Main");
            controllerPid = CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(pgrep.getInputStream())));
            root.warn(controllerPid);
            runtime.exec("kill -9 " + controllerPid);
            Thread.sleep(10000L);
        } while (!controllerPid.isEmpty());
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    ScaleUtil.deleteFolder(f);
                    continue;
                }
                if (f.delete()) continue;
                root.warn("Failed to delete {}", (Object)f);
            }
        }
        if (!folder.delete()) {
            root.warn("Failed to delete {}", (Object)folder);
        }
    }

    private static void waitNetconfTopologyReady(TesttoolParameters params) {
        root.info("Wait for Netconf topology to be accessible via Restconf");
        HttpResponse<String> response = ScaleUtil.requestNetconfTopology(params);
        while (response == null || response.statusCode() != 200 && response.statusCode() != 204) {
            if (response == null) {
                root.warn("Failed to get response from controller, going to sleep...");
            } else {
                root.warn("Received status code {}, going to sleep...", (Object)response.statusCode());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Sleep interrupted", e);
            }
            response = ScaleUtil.requestNetconfTopology(params);
        }
        root.info("Returned status code {}, Netconf topology is accessible", (Object)response.statusCode());
    }

    private static HttpResponse<String> requestNetconfTopology(final TesttoolParameters params) {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(Integer.MAX_VALUE)).authenticator(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(params.controllerAuthUsername, params.controllerAuthPassword.toCharArray());
            }
        }).build();
        HttpRequest request = HttpRequest.newBuilder(URI.create(String.format(RESTCONF_URL, params.controllerIp, params.controllerPort))).GET().header("Content-Type", "application/json").header("Accept", "application/json").build();
        try {
            return httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException e) {
            root.warn(e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted while waiting for response", e);
        }
    }

    private static final class TimeoutGuard
    implements Callable<Void> {
        private TimeoutGuard() {
        }

        @Override
        public Void call() {
            resultsLog.warn("Timeout for scale test reached after: {} ..aborting", (Object)STOPWATCH);
            root.warn("Timeout for scale test reached after: {} ..aborting", (Object)STOPWATCH);
            System.exit(0);
            return null;
        }
    }

    private static class ScaleVerifyCallable
    implements Callable<Void> {
        private static final Logger LOG = LoggerFactory.getLogger(ScaleVerifyCallable.class);
        private static final Pattern PATTERN = Pattern.compile("connected");
        private final HttpClient httpClient;
        private final HttpRequest request;
        private final int deviceCount;

        ScaleVerifyCallable(final TesttoolParameters params) {
            this.deviceCount = params.deviceCount;
            this.httpClient = HttpClient.newBuilder().authenticator(new Authenticator(this){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(params.controllerAuthUsername, params.controllerAuthPassword.toCharArray());
                }
            }).build();
            this.request = HttpRequest.newBuilder(URI.create(String.format(ScaleUtil.RESTCONF_URL, params.controllerIp, params.controllerPort))).GET().header("Content-Type", "application/xml").header("Accept", "application/xml").build();
        }

        @Override
        public Void call() throws Exception {
            LOG.info("Checking number of connected devices.");
            try {
                HttpResponse<String> response = this.httpClient.send(this.request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200 && response.statusCode() != 204) {
                    LOG.warn("Request failed, status code: {}", (Object)response.statusCode());
                    EXECUTOR.schedule(this, 10L, TimeUnit.SECONDS);
                } else {
                    String body = response.body();
                    Matcher matcher = PATTERN.matcher(body);
                    int count = 0;
                    while (matcher.find()) {
                        ++count;
                    }
                    resultsLog.info("Currently connected devices : {} out of {}, time elapsed: {}", new Object[]{count, this.deviceCount, STOPWATCH});
                    if (count != this.deviceCount) {
                        EXECUTOR.schedule(this, 10L, TimeUnit.SECONDS);
                    } else {
                        STOPWATCH.stop();
                        resultsLog.info("All {} of {} devices connected in {}", new Object[]{count, this.deviceCount, STOPWATCH});
                        SEMAPHORE.release();
                    }
                }
            }
            catch (ConnectException e) {
                LOG.warn("Failed to connect to Restconf, is the controller running?", (Throwable)e);
                EXECUTOR.schedule(this, 10L, TimeUnit.SECONDS);
            }
            return null;
        }
    }

    public static class LoggingWrapperExecutor
    extends ScheduledThreadPoolExecutor {
        public LoggingWrapperExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return super.schedule(new LogOnExceptionCallable<V>(callable), delay, unit);
        }

        private static class LogOnExceptionCallable<T>
        implements Callable<T> {
            private final Callable<T> theCallable;

            LogOnExceptionCallable(Callable<T> theCallable) {
                this.theCallable = theCallable;
            }

            @Override
            public T call() {
                try {
                    return this.theCallable.call();
                }
                catch (Exception e) {
                    root.warn("error in executing: " + String.valueOf(this.theCallable) + ". It will no longer be run!", (Throwable)e);
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

