/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.opendaylight.netconf.test.tool.TesttoolParameters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.Credentials;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.credentials.credentials.login.pw.unencrypted.LoginPasswordUnencrypted;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.svc.v1.urn.opendaylight.netconf.node.topology.rev240911.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PayloadCreator {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadCreator.class);
    private static final EffectiveModelContext NETWORK_TOPOLOGY_SCHEMA_CONTEXT = BindingRuntimeHelpers.createEffectiveModel(List.of(YangModuleInfoImpl.getInstance()));
    private static final JSONCodecFactory NETWORK_TOPOLOGY_JSON_CODEC_FACTORY = JSONCodecFactorySupplier.RFC7951.getShared(NETWORK_TOPOLOGY_SCHEMA_CONTEXT);
    private static final QName TOPOLOGY_ID_QNAME = QName.create((QName)Topology.QNAME, (String)"topology-id").intern();
    private static final QName NODE_ID_QNAME = QName.create((QName)Node.QNAME, (String)"node-id").intern();
    private static final YangInstanceIdentifier.NodeIdentifier NETCONF_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"netconf-node"));
    private static final YangInstanceIdentifier.NodeIdentifier PORT_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"port"));
    private static final YangInstanceIdentifier.NodeIdentifier HOST_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"host"));
    private static final YangInstanceIdentifier.NodeIdentifier USERNAME_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"username"));
    private static final YangInstanceIdentifier.NodeIdentifier PASSWORD_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"password"));
    private static final YangInstanceIdentifier.NodeIdentifier CREDENTIALS_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)Credentials.QNAME.bindTo(PORT_NODE_IDENTIFIER.getNodeType().getModule()).intern());
    private static final YangInstanceIdentifier.NodeIdentifier LOGIN_PASSWORD_UNENCRYPTED_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)LoginPasswordUnencrypted.QNAME.bindTo(PORT_NODE_IDENTIFIER.getNodeType().getModule()).intern());
    private static final YangInstanceIdentifier.NodeIdentifier TCP_ONLY_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"tcp-only"));
    private static final YangInstanceIdentifier.NodeIdentifier KEEPALIVE_DELAY_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"keepalive-delay"));
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMALESS_NODE_IDENTIFIER = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"schemaless"));
    private static final String DEFAULT_TOPOLOGY_ID = "topology-netconf";
    private static final String DEFAULT_NODE_PASSWORD = "admin";
    private static final String DEFAULT_NODE_USERNAME = "admin";
    private static final boolean DEFAULT_NODE_SCHEMALESS = false;
    private static final int DEFAULT_NODE_KEEPALIVE_DELAY = 0;
    private static final int DEFAULT_REQUEST_PAYLOAD_INDENTATION = 2;

    private PayloadCreator() {
    }

    static String createStringPayload(List<Integer> devices, TesttoolParameters parameters) {
        return PayloadCreator.normalizedNodeToString(PayloadCreator.createNormalizedNodePayload(devices, parameters));
    }

    private static String normalizedNodeToString(SystemMapNode node) {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = JsonWriterFactory.createJsonWriter((Writer)writer, (int)2);
        NormalizedNodeStreamWriter jsonStream = JSONNormalizedNodeStreamWriter.createExclusiveWriter((JSONCodecFactory)NETWORK_TOPOLOGY_JSON_CODEC_FACTORY, (SchemaNodeIdentifier.Absolute)SchemaNodeIdentifier.Absolute.of((QName)NetworkTopology.QNAME), null, (JsonWriter)jsonWriter);
        try (NormalizedNodeWriter nodeWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)jsonStream);){
            nodeWriter.write((NormalizedNode)node);
        }
        catch (IOException e) {
            LOG.error("Failed to serialize node: {} to JSON", (Object)node, (Object)e);
            throw new IllegalStateException("Failed to serialize node to JSON", e);
        }
        return writer.toString();
    }

    private static SystemMapNode createNormalizedNodePayload(List<Integer> devices, TesttoolParameters parameters) {
        CollectionNodeBuilder nodeBuilder = ImmutableNodes.newSystemMapBuilder().withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)Node.QNAME));
        for (Integer device : devices) {
            nodeBuilder.withChild((NormalizedNode)((MapEntryNode)ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Node.QNAME, (QName)NODE_ID_QNAME, (Object)(device + "-sim-device"))).withChild((DataContainerChild)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NETCONF_NODE_IDENTIFIER).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)PORT_NODE_IDENTIFIER, (Object)Uint16.valueOf((int)device))).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)HOST_NODE_IDENTIFIER, (Object)parameters.generateConfigsAddress)).withChild((DataContainerChild)ImmutableNodes.newChoiceBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)CREDENTIALS_NODE_IDENTIFIER).withChild((DataContainerChild)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)LOGIN_PASSWORD_UNENCRYPTED_NODE_IDENTIFIER).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)USERNAME_NODE_IDENTIFIER, (Object)"admin")).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)PASSWORD_NODE_IDENTIFIER, (Object)"admin")).build()).build()).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)TCP_ONLY_NODE_IDENTIFIER, (Object)(!parameters.ssh ? 1 : 0))).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)KEEPALIVE_DELAY_NODE_IDENTIFIER, (Object)0)).withChild((DataContainerChild)ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)SCHEMALESS_NODE_IDENTIFIER, (Object)false)).build()).build()));
        }
        return (SystemMapNode)ImmutableNodes.newSystemMapBuilder().withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier.create((QName)Topology.QNAME)).withChild((NormalizedNode)((MapEntryNode)ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Topology.QNAME, (QName)TOPOLOGY_ID_QNAME, (Object)DEFAULT_TOPOLOGY_ID)).withChild((DataContainerChild)nodeBuilder.build()).build())).build();
    }
}

