/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.bootstrap.ServerBootstrap;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.auth.AuthProvider;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.common.impl.DefaultNetconfTimer;
import org.opendaylight.netconf.server.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.netconf.server.ServerTransportInitializer;
import org.opendaylight.netconf.server.api.SessionIdProvider;
import org.opendaylight.netconf.server.api.monitoring.BasicCapability;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.monitoring.YangModuleCapability;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.impl.DefaultSessionIdProvider;
import org.opendaylight.netconf.server.osgi.AggregatedNetconfOperationServiceFactory;
import org.opendaylight.netconf.shaded.sshd.common.keyprovider.KeyPairProvider;
import org.opendaylight.netconf.shaded.sshd.server.auth.password.UserAuthPasswordFactory;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.opendaylight.netconf.shaded.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;
import org.opendaylight.netconf.test.tool.DummyMonitoringService;
import org.opendaylight.netconf.test.tool.FakeCapability;
import org.opendaylight.netconf.test.tool.MdsalOperationProvider;
import org.opendaylight.netconf.test.tool.SimulatedOperationProvider;
import org.opendaylight.netconf.test.tool.TesttoolNegotiationFactory;
import org.opendaylight.netconf.test.tool.VirtualKeyPairProvider;
import org.opendaylight.netconf.test.tool.config.Configuration;
import org.opendaylight.netconf.test.tool.customrpc.SettableOperationProvider;
import org.opendaylight.netconf.test.tool.monitoring.NetconfMonitoringOperationServiceFactory;
import org.opendaylight.netconf.test.tool.operations.DefaultOperationsCreator;
import org.opendaylight.netconf.test.tool.operations.OperationsProvider;
import org.opendaylight.netconf.test.tool.rpchandler.SettableOperationRpcProvider;
import org.opendaylight.netconf.test.tool.schemacache.SchemaSourceCache;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.TransportStack;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.ssh.SSHTransportStackFactory;
import org.opendaylight.netconf.transport.ssh.ServerFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.tcp.TCPServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.listen.stack.grouping.transport.ssh.ssh.TcpServerParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.tcp.server.grouping.LocalBindBuilder;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.Submodule;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.fs.FilesystemSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.spi.source.URLYangTextSource;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToIRTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDeviceSimulator
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceSimulator.class);
    private final DefaultNetconfTimer timer = new DefaultNetconfTimer();
    private final Configuration configuration;
    private final List<TransportStack> servers;
    private final SSHTransportStackFactory sshStackFactory;
    private EffectiveModelContext schemaContext;
    private boolean sendFakeSchema = false;

    public NetconfDeviceSimulator(Configuration configuration) {
        this.configuration = configuration;
        this.servers = new ArrayList<TransportStack>(configuration.getDeviceCount());
        this.sshStackFactory = new SSHTransportStackFactory("netconf-device-simulator-threads", configuration.getThreadPoolSize());
    }

    private ServerTransportInitializer createTransportInitializer(Set<Capability> capabilities, DOMSchemaService.YangTextSourceExtension sourceProvider) {
        HashSet<Capability> transformedCapabilities = new HashSet<Capability>(Collections2.transform(capabilities, input -> {
            if (this.sendFakeSchema) {
                this.sendFakeSchema = false;
                return new FakeCapability((YangModuleCapability)input);
            }
            return input;
        }));
        transformedCapabilities.add((Capability)new BasicCapability("urn:ietf:params:netconf:capability:candidate:1.0"));
        DummyMonitoringService monitoringService1 = new DummyMonitoringService(transformedCapabilities);
        DefaultSessionIdProvider idProvider = new DefaultSessionIdProvider();
        NetconfOperationServiceFactory aggregatedNetconfOperationServiceFactory = this.createOperationServiceFactory(sourceProvider, transformedCapabilities, monitoringService1, (SessionIdProvider)idProvider);
        return new ServerTransportInitializer((NetconfServerSessionNegotiatorFactory)new TesttoolNegotiationFactory((NetconfTimer)this.timer, aggregatedNetconfOperationServiceFactory, (SessionIdProvider)idProvider, this.configuration.getGenerateConfigsTimeout(), monitoringService1, this.configuration.getCapabilities()));
    }

    private NetconfOperationServiceFactory createOperationServiceFactory(DOMSchemaService.YangTextSourceExtension sourceProvider, Set<Capability> transformedCapabilities, NetconfMonitoringService monitoringService1, SessionIdProvider idProvider) {
        Object operationProvider;
        AggregatedNetconfOperationServiceFactory aggregatedNetconfOperationServiceFactory = new AggregatedNetconfOperationServiceFactory();
        if (this.configuration.isMdSal()) {
            LOG.info("using MdsalOperationProvider.");
            operationProvider = new MdsalOperationProvider(idProvider, transformedCapabilities, this.schemaContext, sourceProvider);
        } else if (this.configuration.isXmlConfigurationProvided()) {
            LOG.info("using SimulatedOperationProvider.");
            operationProvider = new SimulatedOperationProvider(transformedCapabilities, Optional.ofNullable(this.configuration.getNotificationFile()), Optional.ofNullable(this.configuration.getInitialConfigXMLFile()));
        } else if (this.configuration.isNotificationsSupported()) {
            LOG.info("using SimulatedOperationProvider.");
            operationProvider = new SimulatedOperationProvider(transformedCapabilities, Optional.ofNullable(this.configuration.getNotificationFile()), Optional.empty());
        } else {
            LOG.info("using OperationsProvider.");
            operationProvider = new OperationsProvider(transformedCapabilities, Objects.requireNonNullElseGet(this.configuration.getOperationsCreator(), DefaultOperationsCreator::new));
        }
        NetconfMonitoringOperationServiceFactory monitoringService = new NetconfMonitoringOperationServiceFactory(monitoringService1);
        aggregatedNetconfOperationServiceFactory.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)operationProvider);
        aggregatedNetconfOperationServiceFactory.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)monitoringService);
        if (this.configuration.getRpcConfigFile() != null) {
            SettableOperationProvider settableService = new SettableOperationProvider(this.configuration.getRpcConfigFile());
            aggregatedNetconfOperationServiceFactory.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)settableService);
        } else {
            SettableOperationRpcProvider settableService = new SettableOperationRpcProvider(this.configuration.getRpcHandler());
            aggregatedNetconfOperationServiceFactory.onAddNetconfOperationServiceFactory((NetconfOperationServiceFactory)settableService);
        }
        return aggregatedNetconfOperationServiceFactory;
    }

    public List<Integer> start() {
        Integer last;
        String proto = this.configuration.isSsh() ? "SSH" : "TCP";
        LOG.info("Starting {}, {} simulated devices starting on port {}", new Object[]{this.configuration.getDeviceCount(), proto, this.configuration.getStartingPort()});
        SharedSchemaRepository schemaRepo = new SharedSchemaRepository("netconf-simulator");
        Set<Capability> capabilities = this.parseSchemasToModuleCapabilities(schemaRepo);
        ServerTransportInitializer transportInitializer = this.createTransportInitializer(capabilities, sourceIdentifier -> schemaRepo.getSchemaSource(sourceIdentifier, YangTextSource.class));
        IpAddress ipAddress = NetconfDeviceSimulator.getIpAddress(this.configuration);
        int startingPort = NetconfDeviceSimulator.getStartingPort(this.configuration);
        int deviceCount = this.configuration.getDeviceCount();
        List<Integer> ports = IntStream.range(startingPort, Math.min(startingPort + deviceCount, 65536)).mapToObj(Integer::new).toList();
        ArrayList<Integer> openDevices = new ArrayList<Integer>(ports.size());
        ServerFactoryManagerConfigurator configurator = this.configuration.isSsh() ? NetconfDeviceSimulator.createServerFactoryManagerConfigurator(this.configuration) : null;
        LOG.debug("Ports: {}", ports);
        for (int port : ports) {
            try {
                TcpServerGrouping connectParams = NetconfDeviceSimulator.connectionParams(ipAddress, port);
                ListenableFuture serverFuture = this.configuration.isSsh() ? this.sshStackFactory.listenServer("netconf", (TransportChannelListener)transportInitializer, connectParams, null, configurator) : TCPServer.listen((TransportChannelListener)transportInitializer, (ServerBootstrap)this.sshStackFactory.newServerBootstrap(), (TcpServerGrouping)connectParams);
                this.servers.add((TransportStack)serverFuture.get());
                openDevices.add(port);
            }
            catch (InterruptedException | ExecutionException | UnsupportedConfigurationException e) {
                LOG.error("Could not start {} simulated device on port {}", new Object[]{proto, port, e});
                break;
            }
        }
        Integer first = (Integer)openDevices.get(0);
        Integer n = last = openDevices.isEmpty() ? null : (Integer)openDevices.get(openDevices.size() - 1);
        if (openDevices.size() == this.configuration.getDeviceCount()) {
            LOG.info("All simulated devices started successfully from port {} to {}", (Object)first, (Object)last);
        } else if (openDevices.isEmpty()) {
            LOG.warn("No simulated devices started.");
        } else {
            LOG.warn("Not all simulated devices started successfully. Started devices are on ports {} to {}", (Object)first, (Object)last);
        }
        return openDevices;
    }

    private static ServerFactoryManagerConfigurator createServerFactoryManagerConfigurator(Configuration configuration) {
        AuthProvider authProvider = configuration.getAuthProvider();
        PublickeyAuthenticator publicKeyAuthenticator = configuration.getPublickeyAuthenticator();
        return factoryManager -> {
            ImmutableList.Builder authFactoriesListBuilder = ImmutableList.builder();
            authFactoriesListBuilder.add((Object)new UserAuthPasswordFactory());
            factoryManager.setPasswordAuthenticator((usr, pass, session) -> authProvider.authenticated(usr, pass));
            if (publicKeyAuthenticator != null) {
                UserAuthPublicKeyFactory factory = new UserAuthPublicKeyFactory();
                factory.setSignatureFactories(factoryManager.getSignatureFactories());
                authFactoriesListBuilder.add((Object)factory);
                factoryManager.setPublickeyAuthenticator(publicKeyAuthenticator);
            }
            factoryManager.setUserAuthFactories((List)authFactoriesListBuilder.build());
            factoryManager.setKeyPairProvider((KeyPairProvider)new VirtualKeyPairProvider());
        };
    }

    private Set<Capability> parseSchemasToModuleCapabilities(SharedSchemaRepository consumer) {
        final HashSet loadedSources = new HashSet();
        consumer.registerSchemaSourceListener((SchemaSourceListener)TextToIRTransformer.create((SchemaRepository)consumer, (SchemaSourceRegistry)consumer));
        consumer.registerSchemaSourceListener(new SchemaSourceListener(){

            public void schemaSourceEncountered(SourceRepresentation schemaSourceRepresentation) {
            }

            public void schemaSourceRegistered(Iterable<PotentialSchemaSource<?>> potentialSchemaSources) {
                for (PotentialSchemaSource<?> potentialSchemaSource : potentialSchemaSources) {
                    loadedSources.add(potentialSchemaSource.getSourceIdentifier());
                }
            }

            public void schemaSourceUnregistered(PotentialSchemaSource<?> potentialSchemaSource) {
            }
        });
        if (this.configuration.getSchemasDir() != null) {
            LOG.info("Loading models from directory.");
            cache = new FilesystemSchemaSourceCache((SchemaSourceRegistry)consumer, YangTextSource.class, this.configuration.getSchemasDir());
            consumer.registerSchemaSourceListener((SchemaSourceListener)cache);
        } else if (this.configuration.getModels() != null) {
            LOG.info("Loading models from classpath.");
            cache = new SchemaSourceCache<YangTextSource>((SchemaSourceRegistry)consumer, YangTextSource.class, this.configuration.getModels());
            consumer.registerSchemaSourceListener((SchemaSourceListener)cache);
        } else {
            LOG.info("Custom module loading skipped.");
        }
        this.configuration.getDefaultYangResources().forEach(r -> NetconfDeviceSimulator.registerSource(consumer, r.resourcePath(), new SourceIdentifier(r.moduleName(), r.revision())));
        try {
            this.schemaContext = (EffectiveModelContext)consumer.createEffectiveModelContextFactory().createEffectiveModelContext(loadedSources).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Cannot parse schema context. Please read stack trace and check YANG files in schema directory.", e);
        }
        HashSet<Capability> capabilities = new HashSet<Capability>();
        for (Module module : this.schemaContext.getModules()) {
            for (Submodule subModule : module.getSubmodules()) {
                NetconfDeviceSimulator.addModuleCapability(consumer, capabilities, (ModuleLike)subModule);
            }
            NetconfDeviceSimulator.addModuleCapability(consumer, capabilities, (ModuleLike)module);
        }
        return capabilities;
    }

    private static void addModuleCapability(SharedSchemaRepository consumer, Set<Capability> capabilities, ModuleLike module) {
        String moduleContent;
        String moduleNamespace = module.getNamespace().toString();
        String moduleName = module.getName();
        String revision = module.getRevision().map(Revision::toString).orElse(null);
        SourceIdentifier sourceId = new SourceIdentifier(moduleName, revision);
        try {
            moduleContent = ((YangTextSource)consumer.getSchemaSource(sourceId, YangTextSource.class).get()).read();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Cannot retrieve schema source for module " + String.valueOf(sourceId) + " from schema repository", e);
        }
        capabilities.add((Capability)new YangModuleCapability(moduleNamespace, moduleName, revision, moduleContent));
    }

    private static void registerSource(SharedSchemaRepository consumer, String resource, SourceIdentifier sourceId) {
        consumer.registerSchemaSource(sourceIdentifier -> Futures.immediateFuture((Object)new URLYangTextSource(NetconfDeviceSimulator.class.getResource(resource))), PotentialSchemaSource.create((SourceIdentifier)sourceId, YangTextSource.class, (int)PotentialSchemaSource.Costs.IMMEDIATE.getValue()));
    }

    private static IpAddress getIpAddress(Configuration configuration) {
        try {
            return IetfInetUtil.ipAddressFor((InetAddress)InetAddress.getByName(configuration.getIp()));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Cannot resolve address " + configuration.getIp(), e);
        }
    }

    private static int getStartingPort(Configuration configuration) {
        int startingPort = configuration.getStartingPort();
        if (startingPort > 0 && startingPort < 65536) {
            return startingPort;
        }
        try {
            ServerSocket socket = new ServerSocket(0);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find available port", e);
        }
    }

    private static TcpServerGrouping connectionParams(IpAddress address, int port) {
        return new TcpServerParametersBuilder().setLocalBind(BindingMap.of((EntryObject)new LocalBindBuilder().setLocalAddress(address).setLocalPort(new PortNumber(Uint16.valueOf((int)port))).build())).build();
    }

    @Override
    public void close() {
        for (TransportStack server : this.servers) {
            try {
                server.shutdown().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.debug("Exception on simulated device shutdown", (Throwable)e);
            }
        }
        this.sshStackFactory.close();
    }
}

