/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.SerializedDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.FixedDOMSchemaService;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStore;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStoreFactory;
import org.opendaylight.netconf.server.api.SessionIdProvider;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.CapabilityListener;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.mdsal.CurrentSchemaContext;
import org.opendaylight.netconf.server.mdsal.TransactionProvider;
import org.opendaylight.netconf.server.mdsal.operations.Commit;
import org.opendaylight.netconf.server.mdsal.operations.DiscardChanges;
import org.opendaylight.netconf.server.mdsal.operations.EditConfig;
import org.opendaylight.netconf.server.mdsal.operations.Get;
import org.opendaylight.netconf.server.mdsal.operations.GetConfig;
import org.opendaylight.netconf.server.mdsal.operations.Lock;
import org.opendaylight.netconf.server.mdsal.operations.Unlock;
import org.opendaylight.netconf.test.tool.DummyMonitoringService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.SpecialExecutors;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MdsalOperationProvider
implements NetconfOperationServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MdsalOperationProvider.class);
    private final Set<Capability> caps;
    private final DOMSchemaService.YangTextSourceExtension sourceProvider;
    private final DOMSchemaService schemaService;

    MdsalOperationProvider(SessionIdProvider idProvider, Set<Capability> caps, EffectiveModelContext schemaContext, DOMSchemaService.YangTextSourceExtension sourceProvider) {
        this.caps = caps;
        this.schemaService = new FixedDOMSchemaService(schemaContext);
        this.sourceProvider = sourceProvider;
    }

    public Set<Capability> getCapabilities() {
        return this.caps;
    }

    public Registration registerCapabilityListener(CapabilityListener listener) {
        listener.onCapabilitiesChanged(this.caps, Set.of());
        return () -> {};
    }

    public NetconfOperationService createService(SessionIdType sessionId) {
        return new MdsalOperationService(sessionId, this.schemaService, this.caps, this.sourceProvider);
    }

    static class MdsalOperationService
    implements NetconfOperationService {
        private final SessionIdType currentSessionId;
        private final DOMSchemaService schemaService;
        private final Set<Capability> caps;
        private final DOMDataBroker dataBroker;
        private final DOMSchemaService.YangTextSourceExtension sourceProvider;

        MdsalOperationService(SessionIdType currentSessionId, DOMSchemaService schemaService, Set<Capability> caps, DOMSchemaService.YangTextSourceExtension sourceProvider) {
            this.currentSessionId = Objects.requireNonNull(currentSessionId);
            this.schemaService = Objects.requireNonNull(schemaService);
            this.caps = caps;
            this.sourceProvider = sourceProvider;
            this.dataBroker = MdsalOperationService.createDataStore(schemaService, currentSessionId);
        }

        public Set<NetconfOperation> getNetconfOperations() {
            ContainerNode netconf = this.createNetconfState();
            DOMDataTreeWriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
            tx.put(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.of((QName)NetconfState.QNAME), (NormalizedNode)netconf);
            try {
                tx.commit().get();
                LOG.debug("Netconf state updated successfully");
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Unable to update netconf state", (Throwable)e);
            }
            TransactionProvider transactionProvider = new TransactionProvider(this.dataBroker, this.currentSessionId);
            CurrentSchemaContext currentSchemaContext = CurrentSchemaContext.create((DOMSchemaService)this.schemaService, (DOMSchemaService.YangTextSourceExtension)this.sourceProvider);
            Get get = new Get(this.currentSessionId, currentSchemaContext, transactionProvider);
            EditConfig editConfig = new EditConfig(this.currentSessionId, currentSchemaContext, transactionProvider);
            GetConfig getConfig = new GetConfig(this.currentSessionId, currentSchemaContext, transactionProvider);
            Commit commit = new Commit(this.currentSessionId, transactionProvider);
            Lock lock = new Lock(this.currentSessionId);
            Unlock unLock = new Unlock(this.currentSessionId);
            DiscardChanges discardChanges = new DiscardChanges(this.currentSessionId, transactionProvider);
            return Set.of(get, getConfig, editConfig, commit, lock, unLock, discardChanges);
        }

        public void close() {
        }

        private ContainerNode createNetconfState() {
            DummyMonitoringService monitor = new DummyMonitoringService(this.caps);
            QName identifier = QName.create((QName)Schema.QNAME, (String)"identifier");
            QName version = QName.create((QName)Schema.QNAME, (String)"version");
            QName format = QName.create((QName)Schema.QNAME, (String)"format");
            QName location = QName.create((QName)Schema.QNAME, (String)"location");
            QName namespace = QName.create((QName)Schema.QNAME, (String)"namespace");
            CollectionNodeBuilder schemaMapEntryNodeMapNodeCollectionNodeBuilder = ImmutableNodes.newSystemMapBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(Schema.QNAME));
            SystemLeafSetNode locationLeafSet = (SystemLeafSetNode)ImmutableNodes.newSystemLeafSetBuilder().withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(location)).withChildValue((Object)"NETCONF").build();
            HashMap<QName, String> keyValues = new HashMap<QName, String>();
            for (Schema schema : monitor.getSchemas().nonnullSchema().values()) {
                keyValues.put(identifier, schema.getIdentifier());
                keyValues.put(version, schema.getVersion());
                keyValues.put(format, (String)Yang.QNAME);
                schemaMapEntryNodeMapNodeCollectionNodeBuilder.withChild((NormalizedNode)((MapEntryNode)ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)Schema.QNAME, keyValues)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)identifier, (Object)schema.getIdentifier())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)version, (Object)schema.getVersion())).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)format, (Object)Yang.QNAME)).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)namespace, (Object)schema.getNamespace().getValue())).withChild((DataContainerChild)locationLeafSet).build()));
            }
            return (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(NetconfState.QNAME)).withChild((DataContainerChild)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Schemas.QNAME)).withChild((DataContainerChild)schemaMapEntryNodeMapNodeCollectionNodeBuilder.build()).build()).build();
        }

        private static DOMDataBroker createDataStore(DOMSchemaService schemaService, SessionIdType sessionId) {
            LOG.debug("Session {}: Creating data stores for simulated device", (Object)sessionId.getValue());
            InMemoryDOMDataStore configStore = InMemoryDOMDataStoreFactory.create((String)"DOM-CFG", (DOMSchemaService)schemaService);
            InMemoryDOMDataStore operStore = InMemoryDOMDataStoreFactory.create((String)"DOM-OPER", (DOMSchemaService)schemaService);
            ExecutorService listenableFutureExecutor = SpecialExecutors.newBlockingBoundedCachedThreadPool((int)16, (int)16, (String)"CommitFutures", MdsalOperationProvider.class);
            return new SerializedDOMDataBroker(Map.of(LogicalDatastoreType.CONFIGURATION, configStore, LogicalDatastoreType.OPERATIONAL, operStore), (Executor)listenableFutureExecutor);
        }
    }
}

