/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import ch.qos.logback.classic.Level;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.RoundingMode;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opendaylight.netconf.test.tool.Execution;
import org.opendaylight.netconf.test.tool.NetconfDeviceSimulator;
import org.opendaylight.netconf.test.tool.TesttoolParameters;
import org.opendaylight.netconf.test.tool.config.Configuration;
import org.opendaylight.netconf.test.tool.config.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    private Main() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT", "WA_NOT_IN_LOOP"})
    public static void main(String[] args) {
        TesttoolParameters params = TesttoolParameters.parseArgs(args, TesttoolParameters.getParser());
        params.validate();
        ch.qos.logback.classic.Logger root = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(params.debug ? Level.DEBUG : Level.INFO);
        Configuration configuration = new ConfigurationBuilder().from(params).build();
        NetconfDeviceSimulator netconfDeviceSimulator = new NetconfDeviceSimulator(configuration);
        try {
            LOG.debug("Trying to start netconf test-tool with parameters {}", (Object)params);
            List<Integer> openDevices = netconfDeviceSimulator.start();
            if (openDevices.size() == 0) {
                LOG.error("Failed to start any simulated devices, exiting...");
                System.exit(1);
            }
            if (params.controllerIp != null) {
                List<Execution> executionThreads = Main.divideDevicesForThreads(openDevices, params);
                ExecutorService executorService = Executors.newFixedThreadPool(params.threadAmount);
                Stopwatch time = Stopwatch.createStarted();
                List futures = executorService.invokeAll(executionThreads, params.timeOut, TimeUnit.SECONDS);
                int threadNum = 0;
                for (Future future : futures) {
                    ++threadNum;
                    if (future.isCancelled()) {
                        LOG.info("{}. thread timed out.", (Object)threadNum);
                        continue;
                    }
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOG.info("{}. thread failed.", (Object)threadNum, (Object)e);
                    }
                }
                time.stop();
                LOG.info("Time spent with configuration of devices: {}.", (Object)time);
            }
        }
        catch (InterruptedException | RuntimeException e) {
            LOG.error("Unhandled exception", (Throwable)e);
            netconfDeviceSimulator.close();
            System.exit(1);
        }
        NetconfDeviceSimulator netconfDeviceSimulator2 = netconfDeviceSimulator;
        synchronized (netconfDeviceSimulator2) {
            try {
                netconfDeviceSimulator.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting", e);
            }
        }
    }

    private static List<Execution> divideDevicesForThreads(List<Integer> openDevices, TesttoolParameters params) {
        int devicesPerThread = IntMath.divide((int)openDevices.size(), (int)params.threadAmount, (RoundingMode)RoundingMode.UP);
        return Lists.partition(openDevices, (int)devicesPerThread).stream().map(t -> new Execution((List<Integer>)t, params)).collect(Collectors.toList());
    }
}

