/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.test.tool;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.netconf.server.api.monitoring.Capability;
import org.opendaylight.netconf.server.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.monitoring.SessionEvent;
import org.opendaylight.netconf.server.api.monitoring.SessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.SchemaFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.CapabilitiesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SchemasBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SessionsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yangtools.binding.util.BindingMap;
import org.opendaylight.yangtools.concepts.NoOpObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;

public class DummyMonitoringService
implements NetconfMonitoringService {
    private static final Sessions EMPTY_SESSIONS = new SessionsBuilder().build();
    private final Capabilities capabilities;
    private final ArrayListMultimap<String, Capability> capabilityMultiMap;
    private final Schemas schemas;

    public DummyMonitoringService(Set<Capability> capabilities) {
        this.capabilities = new CapabilitiesBuilder().setCapability((Set)capabilities.stream().map(capability -> new Uri(capability.getCapabilityUri())).collect(ImmutableSet.toImmutableSet())).build();
        HashSet moduleCapabilities = new HashSet();
        this.capabilityMultiMap = ArrayListMultimap.create();
        for (Capability cap : capabilities) {
            cap.getModuleName().ifPresent(moduleName -> {
                this.capabilityMultiMap.put(moduleName, (Object)cap);
                moduleCapabilities.add(cap);
            });
        }
        this.schemas = new SchemasBuilder().setSchema(BindingMap.of((Collection)moduleCapabilities.stream().map(capability -> new SchemaBuilder().setIdentifier((String)capability.getModuleName().orElseThrow()).setNamespace(new Uri((String)capability.getModuleNamespace().orElseThrow())).setFormat((SchemaFormat)Yang.VALUE).setVersion(capability.getRevision().orElse("")).setLocation(Set.of(new Schema.Location(Schema.Location.Enumeration.NETCONF))).withKey(new SchemaKey((SchemaFormat)Yang.VALUE, (String)capability.getModuleName().orElseThrow(), capability.getRevision().orElse(""))).build()).collect(Collectors.toList()))).build();
    }

    public Sessions getSessions() {
        return EMPTY_SESSIONS;
    }

    public SessionListener getSessionListener() {
        return new SessionListener(this){

            public void onSessionUp(NetconfManagementSession session) {
            }

            public void onSessionDown(NetconfManagementSession session) {
            }

            public void onSessionEvent(SessionEvent event) {
            }
        };
    }

    public Schemas getSchemas() {
        return this.schemas;
    }

    public String getSchemaForCapability(String moduleName, Optional<String> revision) {
        List capabilityList = this.capabilityMultiMap.get((Object)moduleName);
        if (revision.isPresent()) {
            for (Capability capability : capabilityList) {
                if (!capability.getRevision().orElse("").equals(revision.orElseThrow())) continue;
                return (String)capability.getCapabilitySchema().orElseThrow();
            }
        } else {
            Preconditions.checkState((capabilityList.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 capability for module %s, available revisions : %s", (Object)moduleName, (Object)capabilityList);
            return (String)((Capability)capabilityList.iterator().next()).getCapabilitySchema().orElseThrow();
        }
        throw new IllegalArgumentException("Module with name: " + moduleName + " and revision: " + String.valueOf(revision) + " does not exist");
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public Registration registerCapabilitiesListener(NetconfMonitoringService.CapabilitiesListener listener) {
        return NoOpObjectRegistration.of((Object)listener);
    }

    public Registration registerSessionsListener(NetconfMonitoringService.SessionsListener listener) {
        return NoOpObjectRegistration.of((Object)listener);
    }
}

