/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.endpoints;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.NetconfServerCallhomeStackGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.endpoints.Endpoint;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.endpoints.EndpointKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.callhome.stack.grouping.Transport;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class EndpointBuilder {
    private String _name;
    private Transport _transport;
    private EndpointKey key;
    Map<Class<? extends Augmentation<Endpoint>>, Augmentation<Endpoint>> augmentation = Map.of();

    public EndpointBuilder() {
    }

    public EndpointBuilder(NetconfServerCallhomeStackGrouping arg) {
        this._transport = arg.getTransport();
    }

    public EndpointBuilder(Endpoint base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Endpoint>>, Augmentation<Endpoint>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._transport = base.getTransport();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof NetconfServerCallhomeStackGrouping) {
            NetconfServerCallhomeStackGrouping castArg = (NetconfServerCallhomeStackGrouping)arg;
            this._transport = castArg.getTransport();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[NetconfServerCallhomeStackGrouping]");
    }

    public EndpointKey key() {
        return this.key;
    }

    public String getName() {
        return this._name;
    }

    public Transport getTransport() {
        return this._transport;
    }

    public <E$$ extends Augmentation<Endpoint>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EndpointBuilder withKey(EndpointKey key) {
        this.key = key;
        return this;
    }

    public EndpointBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public EndpointBuilder setTransport(Transport value) {
        this._transport = value;
        return this;
    }

    public EndpointBuilder addAugmentation(Augmentation<Endpoint> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Endpoint>>, Augmentation<Endpoint>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public EndpointBuilder removeAugmentation(Class<? extends Augmentation<Endpoint>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Endpoint build() {
        return new EndpointImpl(this);
    }

    private static final class EndpointImpl
    extends AbstractEntryObject<Endpoint, EndpointKey>
    implements Endpoint {
        private final String _name;
        private final Transport _transport;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EndpointImpl(EndpointBuilder base) {
            super(base.augmentation, (Key)EndpointImpl.extractKey(base));
            EndpointKey key = (EndpointKey)this.key();
            this._name = key.getName();
            this._transport = base.getTransport();
        }

        private static @NonNull EndpointKey extractKey(EndpointBuilder base) {
            EndpointKey key = base.key();
            return key != null ? key : new EndpointKey(base.getName());
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Transport getTransport() {
            return this._transport;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Endpoint.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Endpoint.bindingEquals(this, obj);
        }

        public String toString() {
            return Endpoint.bindingToString(this);
        }
    }
}

