/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.server.rev240814.netconf.server.app.grouping.call.home.netconf.client.ReconnectStrategy;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ReconnectStrategyBuilder {
    private Uint8 _maxAttempts;
    private Uint16 _maxWait;
    private ReconnectStrategy.StartWith _startWith;
    Map<Class<? extends Augmentation<ReconnectStrategy>>, Augmentation<ReconnectStrategy>> augmentation = Map.of();

    public ReconnectStrategyBuilder() {
    }

    public ReconnectStrategyBuilder(ReconnectStrategy base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReconnectStrategy>>, Augmentation<ReconnectStrategy>>(aug);
        }
        this._maxAttempts = base.getMaxAttempts();
        this._maxWait = base.getMaxWait();
        this._startWith = base.getStartWith();
    }

    public static @NonNull ReconnectStrategy empty() {
        return LazyEmpty.INSTANCE;
    }

    public Uint8 getMaxAttempts() {
        return this._maxAttempts;
    }

    public Uint16 getMaxWait() {
        return this._maxWait;
    }

    public ReconnectStrategy.StartWith getStartWith() {
        return this._startWith;
    }

    public <E$$ extends Augmentation<ReconnectStrategy>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkMaxAttemptsRange(short value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..255]]", (int)value);
    }

    public ReconnectStrategyBuilder setMaxAttempts(Uint8 value) {
        if (value != null) {
            ReconnectStrategyBuilder.checkMaxAttemptsRange(value.shortValue());
        }
        this._maxAttempts = value;
        return this;
    }

    private static void checkMaxWaitRange(int value) {
        if (value >= 1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..65535]]", (int)value);
    }

    public ReconnectStrategyBuilder setMaxWait(Uint16 value) {
        if (value != null) {
            ReconnectStrategyBuilder.checkMaxWaitRange(value.intValue());
        }
        this._maxWait = value;
        return this;
    }

    public ReconnectStrategyBuilder setStartWith(ReconnectStrategy.StartWith value) {
        this._startWith = value;
        return this;
    }

    public ReconnectStrategyBuilder addAugmentation(Augmentation<ReconnectStrategy> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReconnectStrategy>>, Augmentation<ReconnectStrategy>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ReconnectStrategyBuilder removeAugmentation(Class<? extends Augmentation<ReconnectStrategy>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ReconnectStrategy build() {
        return new ReconnectStrategyImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull ReconnectStrategy INSTANCE = new ReconnectStrategyBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ReconnectStrategyImpl
    extends AbstractAugmentable<ReconnectStrategy>
    implements ReconnectStrategy {
        private final Uint8 _maxAttempts;
        private final Uint16 _maxWait;
        private final ReconnectStrategy.StartWith _startWith;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ReconnectStrategyImpl(ReconnectStrategyBuilder base) {
            super(base.augmentation);
            this._maxAttempts = base.getMaxAttempts();
            this._maxWait = base.getMaxWait();
            this._startWith = base.getStartWith();
        }

        @Override
        public Uint8 getMaxAttempts() {
            return this._maxAttempts;
        }

        @Override
        public Uint16 getMaxWait() {
            return this._maxWait;
        }

        @Override
        public ReconnectStrategy.StartWith getStartWith() {
            return this._startWith;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ReconnectStrategy.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ReconnectStrategy.bindingEquals(this, obj);
        }

        public String toString() {
            return ReconnectStrategy.bindingToString(this);
        }
    }
}

