/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.spi;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.api.operations.AbstractNetconfOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SubtreeFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SubtreeFilter.class);

    private SubtreeFilter() {
    }

    public static Document applyRpcSubtreeFilter(Document requestDocument, Document rpcReply) throws DocumentedException {
        AbstractNetconfOperation.OperationNameAndNamespace operationNameAndNamespace = new AbstractNetconfOperation.OperationNameAndNamespace(requestDocument);
        if ("urn:ietf:params:xml:ns:netconf:base:1.0".equals(operationNameAndNamespace.getNamespace()) && "get".equals(operationNameAndNamespace.getOperationName()) || "get-config".equals(operationNameAndNamespace.getOperationName())) {
            Optional maybeFilter = operationNameAndNamespace.getOperationElement().getOnlyChildElementOptionally("filter", "urn:ietf:params:xml:ns:netconf:base:1.0");
            if (maybeFilter.isEmpty()) {
                return rpcReply;
            }
            XmlElement filter = (XmlElement)maybeFilter.orElseThrow();
            if (SubtreeFilter.isSupported(filter)) {
                return SubtreeFilter.filtered(filter, rpcReply);
            }
        }
        return rpcReply;
    }

    public static Optional<Document> applySubtreeNotificationFilter(XmlElement filter, Document notification) throws DocumentedException {
        SubtreeFilter.removeEventTimeNode(notification);
        if (SubtreeFilter.isSupported(filter)) {
            return Optional.ofNullable(SubtreeFilter.filteredNotification(filter, notification));
        }
        return Optional.of(SubtreeFilter.extractNotificationContent(notification));
    }

    private static void removeEventTimeNode(Document document) {
        Node eventTimeNode = document.getDocumentElement().getElementsByTagNameNS("urn:ietf:params:xml:ns:netconf:notification:1.0", "eventTime").item(0);
        document.getDocumentElement().removeChild(eventTimeNode);
    }

    private static boolean isSupported(XmlElement filter) {
        return "subtree".equals(filter.getAttribute("type")) || "subtree".equals(filter.getAttribute("type", "urn:ietf:params:xml:ns:netconf:base:1.0"));
    }

    private static Document extractNotificationContent(Document notification) throws DocumentedException {
        XmlElement root = XmlElement.fromDomElement((Element)notification.getDocumentElement());
        XmlElement content = root.getOnlyChildElement();
        notification.removeChild(root.getDomElement());
        notification.appendChild(content.getDomElement());
        return notification;
    }

    private static Document filteredNotification(XmlElement filter, Document originalNotification) throws DocumentedException {
        Document result = XmlUtil.newDocument();
        XmlElement dataSrc = XmlElement.fromDomDocument((Document)originalNotification);
        Element dataDst = (Element)result.importNode(dataSrc.getDomElement(), false);
        for (XmlElement filterChild : filter.getChildElements()) {
            SubtreeFilter.addSubtree2(filterChild, dataSrc.getOnlyChildElement(), XmlElement.fromDomElement((Element)dataDst));
        }
        if (dataDst.getFirstChild() != null) {
            result.appendChild(dataDst.getFirstChild());
            return result;
        }
        return null;
    }

    private static Document filtered(XmlElement filter, Document originalReplyDocument) throws DocumentedException {
        Document result = XmlUtil.newDocument();
        Element rpcReply = originalReplyDocument.getDocumentElement();
        Node rpcReplyDst = result.importNode(rpcReply, false);
        result.appendChild(rpcReplyDst);
        XmlElement dataSrc = XmlElement.fromDomElement((Element)rpcReply).getOnlyChildElement("data", "urn:ietf:params:xml:ns:netconf:base:1.0");
        Element dataDst = (Element)result.importNode(dataSrc.getDomElement(), false);
        rpcReplyDst.appendChild(dataDst);
        SubtreeFilter.addSubtree(filter, dataSrc, XmlElement.fromDomElement((Element)dataDst));
        return result;
    }

    private static void addSubtree(XmlElement filter, XmlElement src, XmlElement dst) throws DocumentedException {
        for (XmlElement srcChild : src.getChildElements()) {
            for (XmlElement filterChild : filter.getChildElements()) {
                SubtreeFilter.addSubtree2(filterChild, srcChild, dst);
            }
        }
    }

    private static MatchingResult addSubtree2(XmlElement filter, XmlElement src, XmlElement dstParent) throws DocumentedException {
        Document document = dstParent.getDomElement().getOwnerDocument();
        MatchingResult matches = SubtreeFilter.matches(src, filter);
        if (matches != MatchingResult.NO_MATCH && matches != MatchingResult.CONTENT_MISMATCH) {
            boolean shouldAppend;
            boolean filterHasChildren = !filter.getChildElements().isEmpty();
            Element copied = (Element)document.importNode(src.getDomElement(), !filterHasChildren);
            boolean bl = shouldAppend = !filterHasChildren;
            if (filterHasChildren) {
                int numberOfTextMatchingChildren = 0;
                for (XmlElement srcChild : src.getChildElements()) {
                    for (XmlElement filterChild : filter.getChildElements()) {
                        MatchingResult childMatch = SubtreeFilter.addSubtree2(filterChild, srcChild, XmlElement.fromDomElement((Element)copied));
                        if (childMatch == MatchingResult.CONTENT_MISMATCH) {
                            return MatchingResult.NO_MATCH;
                        }
                        if (childMatch == MatchingResult.CONTENT_MATCH) {
                            ++numberOfTextMatchingChildren;
                        }
                        shouldAppend |= childMatch != MatchingResult.NO_MATCH;
                    }
                }
                if (numberOfTextMatchingChildren == filter.getChildElements().size()) {
                    copied = (Element)document.importNode(src.getDomElement(), true);
                }
            }
            if (shouldAppend) {
                dstParent.getDomElement().appendChild(copied);
            }
        }
        return matches;
    }

    private static MatchingResult matches(XmlElement src, XmlElement filter) throws DocumentedException {
        MatchingResult result = null;
        if (src.getName().equals(filter.getName()) && Objects.equals(src.namespace(), filter.namespace())) {
            Optional maybeText = filter.getOnlyTextContentOptionally();
            if (maybeText.isPresent()) {
                result = maybeText.equals(src.getOnlyTextContentOptionally()) || SubtreeFilter.prefixedContentMatches(filter, src) ? MatchingResult.CONTENT_MATCH : MatchingResult.CONTENT_MISMATCH;
            }
            if (result == null) {
                for (Attr attr : filter.getAttributes().values()) {
                    if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                    String found = src.getAttribute(attr.getLocalName(), attr.getNamespaceURI());
                    if (attr.getValue().equals(found) && result != MatchingResult.NO_MATCH) {
                        result = MatchingResult.TAG_MATCH;
                        continue;
                    }
                    result = MatchingResult.NO_MATCH;
                }
            }
            if (result == null) {
                result = MatchingResult.TAG_MATCH;
            }
        }
        if (result == null) {
            result = MatchingResult.NO_MATCH;
        }
        LOG.debug("Matching {} to {} resulted in {}", new Object[]{src, filter, result});
        return result;
    }

    private static boolean prefixedContentMatches(XmlElement filter, XmlElement src) throws DocumentedException {
        Map.Entry prefixToNamespaceOfSrc;
        Map.Entry prefixToNamespaceOfFilter;
        try {
            prefixToNamespaceOfFilter = filter.findNamespaceOfTextContent();
            prefixToNamespaceOfSrc = src.findNamespaceOfTextContent();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        String prefix = (String)prefixToNamespaceOfFilter.getKey();
        if (prefix.equals("")) {
            return false;
        }
        if (!((String)prefixToNamespaceOfFilter.getValue()).equals(prefixToNamespaceOfSrc.getValue())) {
            return false;
        }
        String unprefixedFilterContent = filter.getTextContent().substring(((String)prefixToNamespaceOfFilter.getKey()).length() + 1);
        String unprefixedSrcContnet = src.getTextContent().substring(((String)prefixToNamespaceOfSrc.getKey()).length() + 1);
        return unprefixedFilterContent.equals(unprefixedSrcContnet);
    }

    static enum MatchingResult {
        NO_MATCH,
        TAG_MATCH,
        CONTENT_MATCH,
        CONTENT_MISMATCH;

    }
}

