/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.spi;

import com.google.common.primitives.UnsignedInts;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.server.api.monitoring.JavaCommonCounters;
import org.opendaylight.netconf.server.spi.AbstractJavaCommonCounters;
import org.opendaylight.netconf.server.spi.MutableCommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yangtools.concepts.Immutable;

@NonNullByDefault
public final class ImmutableCommonCounters
extends AbstractJavaCommonCounters
implements Immutable {
    private final int inRpcs;
    private final int inBadRpcs;
    private final int outRpcErrors;
    private final int outNotifications;

    private ImmutableCommonCounters(int inRpcs, int inBadRpcs, int outRpcErrors, int outNotifications) {
        this.inRpcs = inRpcs;
        this.inBadRpcs = inBadRpcs;
        this.outRpcErrors = outRpcErrors;
        this.outNotifications = outNotifications;
    }

    private ImmutableCommonCounters(CommonCounters from) {
        this(ImmutableCommonCounters.unwrap(from.requireInRpcs()), ImmutableCommonCounters.unwrap(from.requireInBadRpcs()), ImmutableCommonCounters.unwrap(from.requireOutRpcErrors()), ImmutableCommonCounters.unwrap(from.requireOutNotifications()));
    }

    public static ImmutableCommonCounters copyOf(CommonCounters values) {
        CommonCounters commonCounters = values;
        Objects.requireNonNull(commonCounters);
        CommonCounters commonCounters2 = commonCounters;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ImmutableCommonCounters.class, MutableCommonCounters.class, JavaCommonCounters.class}, (Object)commonCounters2, n)) {
            case 0 -> {
                ImmutableCommonCounters immutable;
                yield immutable = (ImmutableCommonCounters)commonCounters2;
            }
            case 1 -> {
                MutableCommonCounters from = (MutableCommonCounters)commonCounters2;
                yield ImmutableCommonCounters.copyOf(from);
            }
            case 2 -> {
                JavaCommonCounters from = (JavaCommonCounters)commonCounters2;
                yield new ImmutableCommonCounters(UnsignedInts.checkedCast((long)from.inRpcs()), UnsignedInts.checkedCast((long)from.inBadRpcs()), UnsignedInts.checkedCast((long)from.outRpcErrors()), UnsignedInts.checkedCast((long)from.outNotifications()));
            }
            default -> new ImmutableCommonCounters(values);
        };
    }

    public static ImmutableCommonCounters copyOf(MutableCommonCounters values) {
        return new ImmutableCommonCounters(values.rawInRpcs(), values.rawInBadRpcs(), values.rawOutRpcErrors(), values.rawOutNotifications());
    }

    @Deprecated(forRemoval=true, since="8.0.1")
    public static ImmutableCommonCounters copyOf(ImmutableCommonCounters counters) {
        return Objects.requireNonNull(counters);
    }

    public MutableCommonCounters toMutable() {
        return new MutableCommonCounters(this);
    }

    @Override
    int rawInRpcs() {
        return this.inRpcs;
    }

    @Override
    int rawInBadRpcs() {
        return this.inBadRpcs;
    }

    @Override
    int rawOutRpcErrors() {
        return this.outRpcErrors;
    }

    @Override
    int rawOutNotifications() {
        return this.outNotifications;
    }
}

