/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.spi;

import com.google.common.base.MoreObjects;
import org.opendaylight.netconf.server.api.monitoring.JavaCommonCounters;
import org.opendaylight.netconf.server.spi.ImmutableCommonCounters;
import org.opendaylight.netconf.server.spi.MutableCommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.common.Uint32;

abstract sealed class AbstractJavaCommonCounters
implements JavaCommonCounters
permits ImmutableCommonCounters, MutableCommonCounters {
    AbstractJavaCommonCounters() {
    }

    @Override
    public final long inRpcs() {
        return Integer.toUnsignedLong(this.rawInRpcs());
    }

    @Override
    public final long inBadRpcs() {
        return Integer.toUnsignedLong(this.rawInBadRpcs());
    }

    @Override
    public final long outRpcErrors() {
        return Integer.toUnsignedLong(this.rawOutRpcErrors());
    }

    @Override
    public final long outNotifications() {
        return Integer.toUnsignedLong(this.rawOutNotifications());
    }

    public final ZeroBasedCounter32 getInRpcs() {
        return AbstractJavaCommonCounters.wrap(this.rawInRpcs());
    }

    public final ZeroBasedCounter32 getInBadRpcs() {
        return AbstractJavaCommonCounters.wrap(this.rawInBadRpcs());
    }

    public final ZeroBasedCounter32 getOutRpcErrors() {
        return AbstractJavaCommonCounters.wrap(this.rawOutRpcErrors());
    }

    public final ZeroBasedCounter32 getOutNotifications() {
        return AbstractJavaCommonCounters.wrap(this.rawOutNotifications());
    }

    abstract int rawInRpcs();

    abstract int rawInBadRpcs();

    abstract int rawOutRpcErrors();

    abstract int rawOutNotifications();

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("in-rpcs", this.inRpcs()).add("in-bad-rpcs", this.inBadRpcs()).add("out-rpc-errors", this.outRpcErrors()).add("out-notifications", this.outNotifications()).toString();
    }

    static final int unwrap(ZeroBasedCounter32 counter) {
        return counter.getValue().intValue();
    }

    private static ZeroBasedCounter32 wrap(int raw) {
        return new ZeroBasedCounter32(Uint32.fromIntBits((int)raw));
    }
}

