/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.osgi;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.monitoring.SessionListener;
import org.opendaylight.netconf.server.api.notifications.BaseNotificationPublisherRegistration;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.osgi.NetconfCapabilityMonitoringService;
import org.opendaylight.netconf.server.osgi.NetconfSessionMonitoringService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Capabilities;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yangtools.concepts.Registration;

public class NetconfMonitoringServiceImpl
implements NetconfMonitoringService,
AutoCloseable {
    private final NetconfCapabilityMonitoringService capabilityMonitoring;
    private final NetconfSessionMonitoringService sessionMonitoring;
    private final ScheduledExecutorService executorService;

    private NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider, NetconfSessionMonitoringService sessionMonitoring) {
        this.capabilityMonitoring = new NetconfCapabilityMonitoringService(opProvider);
        this.sessionMonitoring = Objects.requireNonNull(sessionMonitoring);
        this.executorService = null;
    }

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider) {
        this(opProvider, new NetconfSessionMonitoringService.WithoutUpdates());
    }

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider, ThreadFactory threadFactory, long period, TimeUnit timeUnit) {
        this.capabilityMonitoring = new NetconfCapabilityMonitoringService(opProvider);
        if (period > 0L) {
            this.executorService = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(0, threadFactory));
            this.sessionMonitoring = new NetconfSessionMonitoringService.WithUpdates(this.executorService, period, timeUnit);
        } else {
            this.executorService = null;
            this.sessionMonitoring = new NetconfSessionMonitoringService.WithoutUpdates();
        }
    }

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactory opProvider, ScheduledExecutorService threadPool, long periodSeconds) {
        this(opProvider, periodSeconds > 0L ? new NetconfSessionMonitoringService.WithUpdates(threadPool, periodSeconds, TimeUnit.SECONDS) : new NetconfSessionMonitoringService.WithoutUpdates());
    }

    @Override
    public Sessions getSessions() {
        return this.sessionMonitoring.getSessions();
    }

    @Override
    public SessionListener getSessionListener() {
        return this.sessionMonitoring;
    }

    @Override
    public Schemas getSchemas() {
        return this.capabilityMonitoring.getSchemas();
    }

    @Override
    public String getSchemaForCapability(String moduleName, Optional<String> revision) {
        return this.capabilityMonitoring.getSchemaForModuleRevision(moduleName, revision);
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilityMonitoring.getCapabilities();
    }

    @Override
    public Registration registerCapabilitiesListener(NetconfMonitoringService.CapabilitiesListener listener) {
        return this.capabilityMonitoring.registerListener(listener);
    }

    @Override
    public Registration registerSessionsListener(NetconfMonitoringService.SessionsListener listener) {
        return this.sessionMonitoring.registerListener(listener);
    }

    public void setNotificationPublisher(BaseNotificationPublisherRegistration notificationPublisher) {
        this.capabilityMonitoring.setNotificationPublisher(notificationPublisher);
    }

    @Override
    public void close() {
        this.capabilityMonitoring.close();
        this.sessionMonitoring.close();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

