/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.api.operations;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.server.api.operations.HandlingPriority;
import org.opendaylight.netconf.server.api.operations.NetconfOperation;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractNetconfOperation
implements NetconfOperation {
    private final @NonNull SessionIdType sessionId;

    protected AbstractNetconfOperation(SessionIdType sessionId) {
        this.sessionId = Objects.requireNonNull(sessionId);
    }

    public final @NonNull SessionIdType sessionId() {
        return this.sessionId;
    }

    @Override
    public final HandlingPriority canHandle(Document message) throws DocumentedException {
        OperationNameAndNamespace operationNameAndNamespace = new OperationNameAndNamespace(message);
        return this.canHandle(operationNameAndNamespace.getOperationName(), operationNameAndNamespace.getNamespace());
    }

    protected HandlingPriority canHandle(String operationName, String operationNamespace) {
        return operationName.equals(this.getOperationName()) && operationNamespace.equals(this.getOperationNamespace()) ? this.getHandlingPriority() : null;
    }

    protected static XmlElement getRequestElementWithCheck(Document message) throws DocumentedException {
        return XmlElement.fromDomElementWithExpected((Element)message.getDocumentElement(), (String)"rpc", (String)"urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    protected @NonNull HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected String getOperationNamespace() {
        return "urn:ietf:params:xml:ns:netconf:base:1.0";
    }

    protected abstract String getOperationName();

    @Override
    public Document handle(Document requestMessage, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        XmlElement requestElement = AbstractNetconfOperation.getRequestElementWithCheck(requestMessage);
        Document document = XmlUtil.newDocument();
        XmlElement operationElement = requestElement.getOnlyChildElement();
        Map attributes = requestElement.getAttributes();
        Element response = this.handle(document, operationElement, subsequentOperation);
        Element rpcReply = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "rpc-reply");
        if (XmlUtil.hasNamespace((Element)response)) {
            rpcReply.appendChild(response);
        } else {
            Element responseNS = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", response.getNodeName());
            NodeList list = response.getChildNodes();
            while (list.getLength() != 0) {
                responseNS.appendChild(list.item(0));
            }
            rpcReply.appendChild(responseNS);
        }
        for (Attr attribute : attributes.values()) {
            rpcReply.setAttributeNode((Attr)document.importNode(attribute, true));
        }
        document.appendChild(rpcReply);
        return document;
    }

    protected abstract Element handle(Document var1, XmlElement var2, @Nullable NetconfOperationChainedExecution var3) throws DocumentedException;

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        try {
            sb.append("{name=").append(this.getOperationName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return sb.append(", namespace=").append(this.getOperationNamespace()).append(", session=").append(this.sessionId.getValue()).append('}').toString();
    }

    public static final class OperationNameAndNamespace {
        private final String operationName;
        private final String namespace;
        private final XmlElement operationElement;

        public OperationNameAndNamespace(Document message) throws DocumentedException {
            XmlElement requestElement = AbstractNetconfOperation.getRequestElementWithCheck(message);
            this.operationElement = requestElement.getOnlyChildElement();
            this.operationName = this.operationElement.getName();
            this.namespace = this.operationElement.getNamespace();
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public XmlElement getOperationElement() {
            return this.operationElement;
        }
    }
}

