/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.api.operations;

import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.server.api.operations.AbstractNetconfOperation;
import org.opendaylight.netconf.server.api.operations.HandlingPriority;
import org.opendaylight.netconf.server.api.operations.NetconfOperationChainedExecution;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractLastNetconfOperation
extends AbstractNetconfOperation {
    protected AbstractLastNetconfOperation(SessionIdType sessionId) {
        super(sessionId);
    }

    @Override
    protected Element handle(Document document, XmlElement operationElement, NetconfOperationChainedExecution subsequentOperation) throws DocumentedException {
        if (subsequentOperation != null) {
            throw new DocumentedException("No netconf operation expected to be subsequent to %s, but is %s".formatted(this, subsequentOperation), ErrorType.APPLICATION, ErrorTag.MALFORMED_MESSAGE, ErrorSeverity.ERROR);
        }
        return this.handleWithNoSubsequentOperations(document, operationElement);
    }

    @Override
    protected HandlingPriority getHandlingPriority() {
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected abstract Element handleWithNoSubsequentOperations(Document var1, XmlElement var2) throws DocumentedException;
}

