/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server.api.monitoring;

import org.opendaylight.netconf.server.api.monitoring.NetconfManagementSession;

public final class SessionEvent {
    private final NetconfManagementSession session;
    private final Type type;

    private SessionEvent(NetconfManagementSession session, Type type) {
        this.session = session;
        this.type = type;
    }

    public NetconfManagementSession getSession() {
        return this.session;
    }

    public Type getType() {
        return this.type;
    }

    public static SessionEvent inRpcSuccess(NetconfManagementSession session) {
        return new SessionEvent(session, Type.IN_RPC_SUCCESS);
    }

    public static SessionEvent inRpcFail(NetconfManagementSession session) {
        return new SessionEvent(session, Type.IN_RPC_FAIL);
    }

    public static SessionEvent outRpcError(NetconfManagementSession session) {
        return new SessionEvent(session, Type.OUT_RPC_ERROR);
    }

    public static SessionEvent notification(NetconfManagementSession session) {
        return new SessionEvent(session, Type.NOTIFICATION);
    }

    public static enum Type {
        IN_RPC_SUCCESS,
        IN_RPC_FAIL,
        OUT_RPC_ERROR,
        NOTIFICATION;

    }
}

