/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.Promise;
import java.util.Objects;
import org.opendaylight.netconf.nettyutil.AbstractChannelInitializer;
import org.opendaylight.netconf.server.DeserializerExceptionHandler;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerTransportInitializer
implements TransportChannelListener<TransportChannel> {
    private static final Logger LOG = LoggerFactory.getLogger(ServerTransportInitializer.class);
    private static final String DESERIALIZER_EX_HANDLER_KEY = "deserializerExHandler";
    private final NetconfServerSessionNegotiatorFactory negotiatorFactory;

    public ServerTransportInitializer(NetconfServerSessionNegotiatorFactory negotiatorFactory) {
        this.negotiatorFactory = Objects.requireNonNull(negotiatorFactory);
    }

    public void onTransportChannelEstablished(TransportChannel channel) {
        LOG.debug("Transport channel {} established", (Object)channel);
        Channel nettyChannel = channel.channel();
        new AbstractChannelInitializer<NetconfServerSession>(){

            protected void initializeMessageDecoder(Channel ch) {
                super.initializeMessageDecoder(ch);
                ch.pipeline().addLast(ServerTransportInitializer.DESERIALIZER_EX_HANDLER_KEY, (ChannelHandler)new DeserializerExceptionHandler());
            }

            protected void initializeSessionNegotiator(Channel ch, Promise<NetconfServerSession> promise) {
                ch.pipeline().addAfter(ServerTransportInitializer.DESERIALIZER_EX_HANDLER_KEY, "negotiator", (ChannelHandler)ServerTransportInitializer.this.negotiatorFactory.getSessionNegotiator(ch, promise));
            }
        }.initialize(nettyChannel, nettyChannel.eventLoop().newPromise());
    }

    public void onTransportChannelFailed(Throwable cause) {
        LOG.error("Transport channel failed", cause);
    }
}

