/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiator;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.NetconfServerSessionListener;
import org.opendaylight.netconf.server.NetconfServerSessionNegotiator;
import org.opendaylight.netconf.server.api.SessionIdProvider;
import org.opendaylight.netconf.server.api.monitoring.NetconfMonitoringService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationService;
import org.opendaylight.netconf.server.api.operations.NetconfOperationServiceFactory;
import org.opendaylight.netconf.server.osgi.NetconfOperationRouterImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

public class NetconfServerSessionNegotiatorFactory {
    public static final ImmutableSet<String> DEFAULT_BASE_CAPABILITIES = ImmutableSet.of((Object)"urn:ietf:params:netconf:base:1.0", (Object)"urn:ietf:params:netconf:base:1.1", (Object)"urn:ietf:params:netconf:capability:exi:1.0", (Object)"urn:ietf:params:netconf:capability:interleave:1.0", (Object)"urn:ietf:params:netconf:capability:notification:1.0");
    private final @NonNegative int maximumIncomingChunkSize;
    private final NetconfTimer timer;
    private final SessionIdProvider idProvider;
    private final NetconfOperationServiceFactory aggregatedOpService;
    private final long connectionTimeoutMillis;
    private final NetconfMonitoringService monitoringService;
    private final Set<String> baseCapabilities;

    protected NetconfServerSessionNegotiatorFactory(NetconfTimer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService, Set<String> baseCapabilities) {
        this(timer, netconfOperationProvider, idProvider, connectionTimeoutMillis, monitoringService, baseCapabilities, NetconfSessionNegotiator.DEFAULT_MAXIMUM_INCOMING_CHUNK_SIZE);
    }

    private NetconfServerSessionNegotiatorFactory(NetconfTimer timer, NetconfOperationServiceFactory netconfOperationProvider, SessionIdProvider idProvider, long connectionTimeoutMillis, NetconfMonitoringService monitoringService, Set<String> baseCapabilities, @NonNegative int maximumIncomingChunkSize) {
        this.timer = Objects.requireNonNull(timer);
        this.aggregatedOpService = netconfOperationProvider;
        this.idProvider = idProvider;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.monitoringService = monitoringService;
        this.maximumIncomingChunkSize = maximumIncomingChunkSize;
        this.baseCapabilities = NetconfServerSessionNegotiatorFactory.validateBaseCapabilities(baseCapabilities == null ? DEFAULT_BASE_CAPABILITIES : baseCapabilities);
    }

    private static ImmutableSet<String> validateBaseCapabilities(Set<String> baseCapabilities) {
        Sets.SetView unknownBaseCaps = Sets.difference(baseCapabilities, DEFAULT_BASE_CAPABILITIES);
        if (!unknownBaseCaps.isEmpty()) {
            throw new IllegalArgumentException("Base capabilities that will be supported by netconf server have to be subset of " + String.valueOf(DEFAULT_BASE_CAPABILITIES) + ", unknown base capabilities: " + String.valueOf(unknownBaseCaps));
        }
        return ImmutableSet.builder().addAll(baseCapabilities).add((Object)"urn:ietf:params:netconf:base:1.0").build();
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public NetconfServerSessionNegotiator getSessionNegotiator(Channel channel, Promise<NetconfServerSession> promise) {
        SessionIdType sessionId = this.idProvider.getNextSessionId();
        NetconfOperationService service = this.getOperationServiceForAddress(sessionId, channel.parent() == null ? null : channel.parent().localAddress());
        HashSet<String> capabilities = new HashSet<String>(this.baseCapabilities);
        for (Uri capability : this.monitoringService.getCapabilities().requireCapability()) {
            capabilities.add(capability.getValue());
        }
        return new NetconfServerSessionNegotiator(HelloMessage.createServerHello(capabilities, (SessionIdType)sessionId), sessionId, promise, channel, this.timer, new NetconfServerSessionListener(new NetconfOperationRouterImpl(service, this.monitoringService, sessionId), this.monitoringService, service), this.connectionTimeoutMillis, this.maximumIncomingChunkSize);
    }

    protected NetconfOperationService getOperationServiceForAddress(SessionIdType sessionId, SocketAddress socketAddress) {
        return this.aggregatedOpService.createService(sessionId);
    }

    protected final NetconfOperationServiceFactory getOperationServiceFactory() {
        return this.aggregatedOpService;
    }

    public static final class Builder {
        private @NonNegative int maximumIncomingChunkSize = NetconfSessionNegotiator.DEFAULT_MAXIMUM_INCOMING_CHUNK_SIZE;
        private NetconfTimer timer;
        private SessionIdProvider idProvider;
        private NetconfOperationServiceFactory aggregatedOpService;
        private long connectionTimeoutMillis;
        private NetconfMonitoringService monitoringService;
        private Set<String> baseCapabilities;

        private Builder() {
        }

        public Builder setTimer(NetconfTimer timer) {
            this.timer = Objects.requireNonNull(timer);
            return this;
        }

        public Builder setIdProvider(SessionIdProvider idProvider) {
            this.idProvider = idProvider;
            return this;
        }

        public Builder setAggregatedOpService(NetconfOperationServiceFactory aggregatedOpService) {
            this.aggregatedOpService = aggregatedOpService;
            return this;
        }

        public Builder setConnectionTimeoutMillis(long connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder setMonitoringService(NetconfMonitoringService monitoringService) {
            this.monitoringService = monitoringService;
            return this;
        }

        public Builder setBaseCapabilities(Set<String> baseCapabilities) {
            this.baseCapabilities = baseCapabilities;
            return this;
        }

        public Builder setMaximumIncomingChunkSize(@NonNegative int maximumIncomingChunkSize) {
            Preconditions.checkArgument((maximumIncomingChunkSize > 0 ? 1 : 0) != 0);
            this.maximumIncomingChunkSize = maximumIncomingChunkSize;
            return this;
        }

        public NetconfServerSessionNegotiatorFactory build() {
            this.validate();
            return new NetconfServerSessionNegotiatorFactory(this.timer, this.aggregatedOpService, this.idProvider, this.connectionTimeoutMillis, this.monitoringService, this.baseCapabilities, this.maximumIncomingChunkSize);
        }

        private void validate() {
            Objects.requireNonNull(this.timer, "timer not initialized");
            Objects.requireNonNull(this.aggregatedOpService, "NetconfOperationServiceFactory not initialized");
            Objects.requireNonNull(this.idProvider, "SessionIdProvider not initialized");
            Preconditions.checkArgument((this.connectionTimeoutMillis > 0L ? 1 : 0) != 0, (Object)"connection time out <=0");
            Objects.requireNonNull(this.monitoringService, "NetconfMonitoringService not initialized");
            if (this.baseCapabilities == null) {
                this.baseCapabilities = DEFAULT_BASE_CAPABILITIES;
            }
        }
    }
}

