/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server;

import io.netty.channel.Channel;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.NetconfDocumentedException;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.messages.HelloMessage;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.common.NetconfTimer;
import org.opendaylight.netconf.nettyutil.AbstractNetconfSession;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiator;
import org.opendaylight.netconf.server.NetconfServerSession;
import org.opendaylight.netconf.server.NetconfServerSessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfServerSessionNegotiator
extends NetconfSessionNegotiator<NetconfServerSession, NetconfServerSessionListener> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfServerSessionNegotiator.class);
    private static final String UNKNOWN = "unknown";
    private final @NonNull SessionIdType sessionId;

    NetconfServerSessionNegotiator(HelloMessage hello, SessionIdType sessionId, Promise<NetconfServerSession> promise, Channel channel, NetconfTimer timer, NetconfServerSessionListener sessionListener, long connectionTimeoutMillis, @NonNegative int maximumIncomingChunkSize) {
        super(hello, promise, channel, timer, (NetconfSessionListener)sessionListener, connectionTimeoutMillis, maximumIncomingChunkSize);
        this.sessionId = Objects.requireNonNull(sessionId);
    }

    protected void handleMessage(HelloMessage netconfMessage) throws NetconfDocumentedException {
        NetconfServerSession session = (NetconfServerSession)this.getSessionForHelloMessage(netconfMessage);
        this.replaceHelloMessageInboundHandler((AbstractNetconfSession)session);
        this.negotiationSuccessful((AbstractNetconfSession)session);
    }

    protected NetconfServerSession getSession(NetconfServerSessionListener sessionListener, Channel channel, HelloMessage message) {
        Optional additionalHeader = message.getAdditionalHeader();
        NetconfHelloMessageAdditionalHeader parsedHeader = additionalHeader.orElseGet(() -> {
            Map.Entry<String, String> hostName = NetconfServerSessionNegotiator.getHostName(channel.localAddress());
            return new NetconfHelloMessageAdditionalHeader(UNKNOWN, hostName.getValue(), hostName.getKey(), "tcp", "client");
        });
        LOG.debug("Additional header from hello parsed as {} from {}", (Object)parsedHeader, (Object)additionalHeader);
        return new NetconfServerSession(sessionListener, channel, this.sessionId, parsedHeader);
    }

    protected static Map.Entry<String, String> getHostName(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return new AbstractMap.SimpleImmutableEntry<String, String>(Integer.toString(inetSocketAddress.getPort()), inetSocketAddress.getHostString());
        }
        if (socketAddress instanceof LocalAddress) {
            LocalAddress localAddress = (LocalAddress)socketAddress;
            return Map.entry(UNKNOWN, localAddress.id());
        }
        return Map.entry(UNKNOWN, UNKNOWN);
    }
}

