/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.NetconfSessionListener;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.messages.NotificationMessage;
import org.opendaylight.netconf.codec.MessageDecoder;
import org.opendaylight.netconf.codec.MessageWriter;
import org.opendaylight.netconf.codec.XMLMessageDecoder;
import org.opendaylight.netconf.codec.XMLMessageWriter;
import org.opendaylight.netconf.nettyutil.AbstractNetconfExiSession;
import org.opendaylight.netconf.server.NetconfServerSessionListener;
import org.opendaylight.netconf.server.api.monitoring.JavaCommonCounters;
import org.opendaylight.netconf.server.api.monitoring.NetconfManagementSession;
import org.opendaylight.netconf.server.spi.MutableCommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.CommonCounters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfSsh;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Transport;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.monitoring.rev220718.NetconfTcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.netconf.monitoring.rev220718.Session1Builder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetconfServerSession
extends AbstractNetconfExiSession<NetconfServerSession, NetconfServerSessionListener>
implements NetconfManagementSession {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfServerSession.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final Pattern DATE_TIME_PATTERN;
    private final @NonNull MutableCommonCounters commonCounters = MutableCommonCounters.of();
    private final NetconfHelloMessageAdditionalHeader header;
    private final NetconfServerSessionListener sessionListener;
    private ZonedDateTime loginTime;
    private volatile boolean delayedClose;

    public NetconfServerSession(NetconfServerSessionListener sessionListener, Channel channel, SessionIdType sessionId, NetconfHelloMessageAdditionalHeader header) {
        super((NetconfSessionListener)sessionListener, channel, sessionId);
        this.header = header;
        this.sessionListener = Objects.requireNonNull(sessionListener);
        LOG.debug("Session {} created", (Object)this);
    }

    public @NonNull JavaCommonCounters commonCounters() {
        return this.commonCounters;
    }

    protected void sessionUp() {
        Preconditions.checkState((this.loginTime == null ? 1 : 0) != 0, (Object)"Session is already up");
        this.loginTime = Instant.now().atZone(ZoneId.systemDefault());
        super.sessionUp();
    }

    public void delayedClose() {
        this.delayedClose = true;
    }

    public ChannelFuture sendMessage(NetconfMessage netconfMessage) {
        ChannelFuture channelFuture = super.sendMessage(netconfMessage);
        if (netconfMessage instanceof NotificationMessage) {
            NotificationMessage notification = (NotificationMessage)netconfMessage;
            this.commonCounters.incOutNotifications();
            this.sessionListener.onNotification(this, notification);
        }
        if (this.delayedClose) {
            channelFuture.addListener(future -> this.close());
        }
        return channelFuture;
    }

    @NonNull MutableCommonCounters counters() {
        return this.commonCounters;
    }

    @Override
    public Session toManagementSession() {
        SocketAddress remoteAddress;
        SessionBuilder builder = new SessionBuilder((CommonCounters)this.commonCounters).setSessionId(this.sessionId().getValue());
        SocketAddress socketAddress = remoteAddress = this.channel.remoteAddress();
        Objects.requireNonNull(socketAddress);
        SocketAddress socketAddress2 = socketAddress;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InetSocketAddress.class}, (Object)socketAddress2, n)) {
            case 0: {
                InetSocketAddress inet = (InetSocketAddress)socketAddress2;
                builder.setSourceHost(new Host(IetfInetUtil.ipAddressFor((InetAddress)inet.getAddress())));
                break;
            }
            default: {
                LOG.debug("Skipping unrecognized source host {}", (Object)remoteAddress);
            }
        }
        String formattedDateTime = DATE_FORMATTER.format(this.loginTime);
        Preconditions.checkState((boolean)DATE_TIME_PATTERN.matcher(formattedDateTime).matches(), (String)"Formatted datetime %s does not match pattern %s", (Object)formattedDateTime, (Object)DATE_TIME_PATTERN);
        return builder.setLoginTime(new DateAndTime(formattedDateTime)).setUsername(this.header.getUserName()).setTransport(NetconfServerSession.getTransportForString(this.header.getTransport())).addAugmentation((Augmentation)new Session1Builder().setSessionIdentifier(this.header.getSessionIdentifier()).build()).build();
    }

    private static Transport getTransportForString(String transport) {
        return switch (transport) {
            case "ssh" -> NetconfSsh.VALUE;
            case "tcp" -> NetconfTcp.VALUE;
            default -> throw new IllegalArgumentException("Unknown transport type " + transport);
        };
    }

    protected NetconfServerSession thisInstance() {
        return this;
    }

    protected void addExiHandlers(MessageDecoder decoder, MessageWriter encoder) {
        this.replaceMessageDecoder(decoder);
        this.setMessageWriterAfterNextMessage(encoder);
    }

    public void stopExiCommunication() {
        this.replaceMessageDecoder((MessageDecoder)new XMLMessageDecoder());
        this.setMessageWriterAfterNextMessage((MessageWriter)XMLMessageWriter.pretty());
    }

    static {
        Verify.verify((DateAndTime.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        DATE_TIME_PATTERN = Pattern.compile((String)DateAndTime.PATTERN_CONSTANTS.get(0));
    }
}

