/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.common.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.netconf.common.NetconfTimer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={NetconfTimer.class}, configurationPid={"org.opendaylight.netconf.timer"})
@Designate(ocd=Configuration.class)
public final class DefaultNetconfTimer
implements NetconfTimer,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNetconfTimer.class);
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("netconf-timer-%d").setDaemon(true).build();
    private HashedWheelTimer delegate;

    @Inject
    public DefaultNetconfTimer() {
        this(100L, TimeUnit.MILLISECONDS, 512);
    }

    public DefaultNetconfTimer(long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this.delegate = new HashedWheelTimer(THREAD_FACTORY, tickDuration, unit, ticksPerWheel);
        LOG.info("NETCONF timer started");
    }

    @Activate
    public DefaultNetconfTimer(Configuration config) {
        this(config.tick$_$duration$_$_millis(), TimeUnit.MILLISECONDS, config.ticks$_$per$_$wheel());
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        HashedWheelTimer local = this.delegate;
        if (local == null) {
            throw new IllegalStateException("Timer has already been stopped");
        }
        return local.newTimeout(Objects.requireNonNull(task), delay, Objects.requireNonNull(unit));
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        if (this.delegate != null) {
            this.delegate.stop();
            this.delegate = null;
            LOG.info("NETCONF timer stopped");
        }
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(description="Duration of each timer tick in milliseconds", min="1")
        public long tick$_$duration$_$_millis() default 100L;

        @AttributeDefinition(description="The size of the timer wheel", min="1", max="1073741824")
        public int ticks$_$per$_$wheel() default 512;
    }
}

