/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import com.google.common.base.VerifyException;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
final class ThreadLocalTransformer
extends ThreadLocal<Transformer> {
    private static final TransformerFactory FACTORY = TransformerFactory.newInstance();
    private final Consumer<Transformer> configurator;

    ThreadLocalTransformer(Consumer<Transformer> configurator) {
        this.configurator = Objects.requireNonNull(configurator);
    }

    @Override
    public void set(Transformer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Transformer initialValue() {
        Transformer transformer;
        try {
            transformer = FACTORY.newTransformer();
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            throw new VerifyException(e);
        }
        this.configurator.accept(transformer);
        return transformer;
    }
}

