/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.codec.ThreadLocalTransformer;

@NonNullByDefault
public abstract class MessageWriter {
    @VisibleForTesting
    static final ThreadLocalTransformer DEFAULT_TRANSFORMER = new ThreadLocalTransformer(transformer -> {});
    @VisibleForTesting
    static final ThreadLocalTransformer PRETTY_TRANSFORMER = new ThreadLocalTransformer(transformer -> {
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "no");
    });
    private final ThreadLocalTransformer threadLocal;

    protected MessageWriter(boolean pretty) {
        this.threadLocal = pretty ? PRETTY_TRANSFORMER : DEFAULT_TRANSFORMER;
    }

    protected final Transformer threadLocalTransformer() {
        return (Transformer)this.threadLocal.get();
    }

    @VisibleForTesting
    public final void writeMessage(NetconfMessage message, OutputStream out) throws IOException, TransformerException {
        this.writeTo(Objects.requireNonNull(message), Objects.requireNonNull(out));
    }

    protected abstract void writeTo(NetconfMessage var1, OutputStream var2) throws IOException, TransformerException;
}

