/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.opendaylight.netconf.codec.FrameDecoder;
import org.opendaylight.netconf.codec.FramingParts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EOMFrameDecoder
extends FrameDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(EOMFrameDecoder.class);
    private static final byte[] EOM = FramingParts.END_OF_MESSAGE;
    private static final int EOM_LENGTH = EOM.length;
    private int bodyLength = 0;

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        ByteBuf frame;
        while ((frame = this.decodeFrame(ctx, in)) != null) {
            out.add(frame);
        }
    }

    @VisibleForTesting
    int bodyLength() {
        return this.bodyLength;
    }

    private ByteBuf decodeFrame(ChannelHandlerContext ctx, ByteBuf in) {
        int readerIndex = in.readerIndex();
        int writerIndex = in.writerIndex();
        int searchIndex = readerIndex + this.bodyLength;
        while (true) {
            int eomIndex;
            if ((eomIndex = in.indexOf(searchIndex, writerIndex, EOM[0])) == -1) {
                this.bodyLength = writerIndex - readerIndex;
                return null;
            }
            int readableBytes = writerIndex - eomIndex;
            if (readableBytes < EOM_LENGTH) {
                LOG.trace("Context {} buffer {} has only {} new bytes", new Object[]{ctx, in, readableBytes});
                this.bodyLength = eomIndex - readerIndex;
                return null;
            }
            if (EOMFrameDecoder.isEom(in, eomIndex)) {
                int frameLength = eomIndex - readerIndex;
                LOG.debug("Context {} buffer {} frame detected: length {}", new Object[]{ctx, in, frameLength});
                ByteBuf ret = in.readRetainedSlice(frameLength);
                in.skipBytes(EOM_LENGTH);
                this.bodyLength = 0;
                return ret;
            }
            searchIndex = eomIndex + 1;
            LOG.trace("Context {} buffer {} restart at {}", new Object[]{ctx, in, searchIndex});
        }
    }

    private static boolean isEom(ByteBuf in, int index) {
        for (int i = 1; i < EOM_LENGTH; ++i) {
            if (in.getByte(index + i) == EOM[i]) continue;
            return false;
        }
        return true;
    }
}

