/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.codec;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.opendaylight.netconf.codec.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChunkedFrameDecoder
extends FrameDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedFrameDecoder.class);
    private static final String GOT_PARAM_WHILE_WAITING_FOR_PARAM = "Got byte {} while waiting for {}";
    private static final String GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM = "Got byte {} while waiting for {}-{}";
    private static final String GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM_PARAM = "Got byte {} while waiting for {}-{}-{}";
    private final int maxChunkSize;
    private State state = State.HEADER_ONE;
    private long chunkSize;
    private CompositeByteBuf chunk;

    public ChunkedFrameDecoder(@NonNegative int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        Preconditions.checkArgument((maxChunkSize > 0 ? 1 : 0) != 0, (String)"Negative maximum chunk size %s", (int)maxChunkSize);
    }

    private static void checkNewLine(byte byteToCheck, String errorMessage) {
        if (byteToCheck != 10) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM, (Object)byteToCheck, (Object)10);
            throw new IllegalStateException(errorMessage);
        }
    }

    private static void checkHash(byte byteToCheck, String errorMessage) {
        if (byteToCheck != 35) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM, (Object)byteToCheck, (Object)35);
            throw new IllegalStateException(errorMessage);
        }
    }

    private void checkChunkSize() {
        if (this.chunkSize > (long)this.maxChunkSize) {
            LOG.debug("Parsed chunk size {}, maximum allowed is {}", (Object)this.chunkSize, (Object)this.maxChunkSize);
            throw new IllegalStateException("Chunk size " + this.chunkSize + " exceeds maximum " + this.maxChunkSize);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws IllegalStateException {
        block11: while (in.isReadable()) {
            switch (this.state.ordinal()) {
                case 0: {
                    byte b = in.readByte();
                    ChunkedFrameDecoder.checkNewLine(b, "Malformed chunk header encountered (byte 0)");
                    this.state = State.HEADER_TWO;
                    this.initChunk();
                    continue block11;
                }
                case 1: {
                    byte b = in.readByte();
                    ChunkedFrameDecoder.checkHash(b, "Malformed chunk header encountered (byte 1)");
                    this.state = State.HEADER_LENGTH_FIRST;
                    continue block11;
                }
                case 2: {
                    byte b = in.readByte();
                    this.chunkSize = ChunkedFrameDecoder.processHeaderLengthFirst(b);
                    this.state = State.HEADER_LENGTH_OTHER;
                    continue block11;
                }
                case 3: {
                    byte b = in.readByte();
                    if (b == 10) {
                        this.state = State.DATA;
                        continue block11;
                    }
                    if (b < 48 || b > 57) {
                        LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM, new Object[]{b, (byte)48, (byte)57});
                        throw new IllegalStateException("Invalid chunk size encountered");
                    }
                    this.chunkSize *= 10L;
                    this.chunkSize += (long)(b - 48);
                    this.checkChunkSize();
                    continue block11;
                }
                case 4: {
                    if ((long)in.readableBytes() < this.chunkSize) {
                        LOG.debug("Buffer has {} bytes, need {} to complete chunk", (Object)in.readableBytes(), (Object)this.chunkSize);
                        in.discardReadBytes();
                        return;
                    }
                    this.aggregateChunks(in.readBytes((int)this.chunkSize));
                    this.state = State.FOOTER_ONE;
                    continue block11;
                }
                case 5: {
                    byte b = in.readByte();
                    ChunkedFrameDecoder.checkNewLine(b, "Malformed chunk footer encountered (byte 0)");
                    this.state = State.FOOTER_TWO;
                    this.chunkSize = 0L;
                    continue block11;
                }
                case 6: {
                    byte b = in.readByte();
                    ChunkedFrameDecoder.checkHash(b, "Malformed chunk footer encountered (byte 1)");
                    this.state = State.FOOTER_THREE;
                    continue block11;
                }
                case 7: {
                    byte b = in.readByte();
                    this.extractNewChunkOrMessageEnd(b);
                    continue block11;
                }
                case 8: {
                    byte b = in.readByte();
                    ChunkedFrameDecoder.checkNewLine(b, "Malformed chunk footer encountered (byte 3)");
                    this.state = State.HEADER_ONE;
                    out.add(this.chunk);
                    this.chunk = null;
                    continue block11;
                }
            }
            LOG.info("Unknown state.");
        }
        in.discardReadBytes();
    }

    private void extractNewChunkOrMessageEnd(byte byteToCheck) {
        if (ChunkedFrameDecoder.isHeaderLengthFirst(byteToCheck)) {
            this.chunkSize = ChunkedFrameDecoder.processHeaderLengthFirst(byteToCheck);
            this.state = State.HEADER_LENGTH_OTHER;
        } else if (byteToCheck == 35) {
            this.state = State.FOOTER_FOUR;
        } else {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM_PARAM, new Object[]{byteToCheck, (byte)35, (byte)49, (byte)57});
            throw new IllegalStateException("Malformed chunk footer encountered (byte 2)");
        }
    }

    private void initChunk() {
        this.chunk = Unpooled.compositeBuffer();
    }

    private void aggregateChunks(ByteBuf newChunk) {
        this.chunk.addComponent(this.chunk.numComponents(), newChunk);
        this.chunk.writerIndex(this.chunk.writerIndex() + newChunk.readableBytes());
    }

    private static int processHeaderLengthFirst(byte byteToCheck) {
        if (!ChunkedFrameDecoder.isHeaderLengthFirst(byteToCheck)) {
            LOG.debug(GOT_PARAM_WHILE_WAITING_FOR_PARAM_PARAM, new Object[]{byteToCheck, (byte)49, (byte)57});
            throw new IllegalStateException("Invalid chunk size encountered (byte 0)");
        }
        return byteToCheck - 48;
    }

    private static boolean isHeaderLengthFirst(byte byteToCheck) {
        return byteToCheck >= 49 && byteToCheck <= 57;
    }

    private static enum State {
        HEADER_ONE,
        HEADER_TWO,
        HEADER_LENGTH_FIRST,
        HEADER_LENGTH_OTHER,
        DATA,
        FOOTER_ONE,
        FOOTER_TWO,
        FOOTER_THREE,
        FOOTER_FOUR;

    }
}

