/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.tls.tls;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.tls.tls.TlsClientParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.TlsClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.ClientIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.HelloParams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.HelloParamsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.Keepalives;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.KeepalivesBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.ServerAuthentication;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.ServerAuthenticationBuilder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class TlsClientParametersBuilder {
    private ClientIdentity _clientIdentity;
    private HelloParams _helloParams;
    private Keepalives _keepalives;
    private ServerAuthentication _serverAuthentication;
    Map<Class<? extends Augmentation<TlsClientParameters>>, Augmentation<TlsClientParameters>> augmentation = Map.of();

    public TlsClientParametersBuilder() {
    }

    public TlsClientParametersBuilder(TlsClientGrouping arg) {
        this._clientIdentity = arg.getClientIdentity();
        this._serverAuthentication = arg.getServerAuthentication();
        this._helloParams = arg.getHelloParams();
        this._keepalives = arg.getKeepalives();
    }

    public TlsClientParametersBuilder(TlsClientParameters base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TlsClientParameters>>, Augmentation<TlsClientParameters>>(aug);
        }
        this._clientIdentity = base.getClientIdentity();
        this._helloParams = base.getHelloParams();
        this._keepalives = base.getKeepalives();
        this._serverAuthentication = base.getServerAuthentication();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof TlsClientGrouping) {
            TlsClientGrouping castArg = (TlsClientGrouping)arg;
            this._clientIdentity = castArg.getClientIdentity();
            this._serverAuthentication = castArg.getServerAuthentication();
            this._helloParams = castArg.getHelloParams();
            this._keepalives = castArg.getKeepalives();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[TlsClientGrouping]");
    }

    public static @NonNull TlsClientParameters empty() {
        return LazyEmpty.INSTANCE;
    }

    public ClientIdentity getClientIdentity() {
        return this._clientIdentity;
    }

    public HelloParams getHelloParams() {
        return this._helloParams;
    }

    public Keepalives getKeepalives() {
        return this._keepalives;
    }

    public ServerAuthentication getServerAuthentication() {
        return this._serverAuthentication;
    }

    public <E$$ extends Augmentation<TlsClientParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TlsClientParametersBuilder setClientIdentity(ClientIdentity value) {
        this._clientIdentity = value;
        return this;
    }

    public TlsClientParametersBuilder setHelloParams(HelloParams value) {
        this._helloParams = value;
        return this;
    }

    public TlsClientParametersBuilder setKeepalives(Keepalives value) {
        this._keepalives = value;
        return this;
    }

    public TlsClientParametersBuilder setServerAuthentication(ServerAuthentication value) {
        this._serverAuthentication = value;
        return this;
    }

    public TlsClientParametersBuilder addAugmentation(Augmentation<TlsClientParameters> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TlsClientParameters>>, Augmentation<TlsClientParameters>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TlsClientParametersBuilder removeAugmentation(Class<? extends Augmentation<TlsClientParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TlsClientParameters build() {
        return new TlsClientParametersImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull TlsClientParameters INSTANCE = new TlsClientParametersBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TlsClientParametersImpl
    extends AbstractAugmentable<TlsClientParameters>
    implements TlsClientParameters {
        private final ClientIdentity _clientIdentity;
        private final HelloParams _helloParams;
        private final Keepalives _keepalives;
        private final ServerAuthentication _serverAuthentication;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TlsClientParametersImpl(TlsClientParametersBuilder base) {
            super(base.augmentation);
            this._clientIdentity = base.getClientIdentity();
            this._helloParams = base.getHelloParams();
            this._keepalives = base.getKeepalives();
            this._serverAuthentication = base.getServerAuthentication();
        }

        public ClientIdentity getClientIdentity() {
            return this._clientIdentity;
        }

        public HelloParams getHelloParams() {
            return this._helloParams;
        }

        public Keepalives getKeepalives() {
            return this._keepalives;
        }

        public ServerAuthentication getServerAuthentication() {
            return this._serverAuthentication;
        }

        public HelloParams nonnullHelloParams() {
            return Objects.requireNonNullElse(this.getHelloParams(), HelloParamsBuilder.empty());
        }

        public Keepalives nonnullKeepalives() {
            return Objects.requireNonNullElse(this.getKeepalives(), KeepalivesBuilder.empty());
        }

        public ServerAuthentication nonnullServerAuthentication() {
            return Objects.requireNonNullElse(this.getServerAuthentication(), ServerAuthenticationBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TlsClientParameters.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TlsClientParameters.bindingEquals(this, obj);
        }

        public String toString() {
            return TlsClientParameters.bindingToString(this);
        }
    }
}

