/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.Ssh;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.NetconfClientParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.NetconfClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.SshClientParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.SshClientParametersBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.TcpServerParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.listen.stack.grouping.transport.ssh.ssh.TcpServerParametersBuilder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

public class SshBuilder {
    private NetconfClientParameters _netconfClientParameters;
    private SshClientParameters _sshClientParameters;
    private TcpServerParameters _tcpServerParameters;
    Map<Class<? extends Augmentation<Ssh>>, Augmentation<Ssh>> augmentation = Map.of();

    public SshBuilder() {
    }

    public SshBuilder(Ssh base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ssh>>, Augmentation<Ssh>>(aug);
        }
        this._netconfClientParameters = base.getNetconfClientParameters();
        this._sshClientParameters = base.getSshClientParameters();
        this._tcpServerParameters = base.getTcpServerParameters();
    }

    public static @NonNull Ssh empty() {
        return LazyEmpty.INSTANCE;
    }

    public NetconfClientParameters getNetconfClientParameters() {
        return this._netconfClientParameters;
    }

    public SshClientParameters getSshClientParameters() {
        return this._sshClientParameters;
    }

    public TcpServerParameters getTcpServerParameters() {
        return this._tcpServerParameters;
    }

    public <E$$ extends Augmentation<Ssh>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SshBuilder setNetconfClientParameters(NetconfClientParameters value) {
        this._netconfClientParameters = value;
        return this;
    }

    public SshBuilder setSshClientParameters(SshClientParameters value) {
        this._sshClientParameters = value;
        return this;
    }

    public SshBuilder setTcpServerParameters(TcpServerParameters value) {
        this._tcpServerParameters = value;
        return this;
    }

    public SshBuilder addAugmentation(Augmentation<Ssh> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ssh>>, Augmentation<Ssh>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SshBuilder removeAugmentation(Class<? extends Augmentation<Ssh>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Ssh build() {
        return new SshImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Ssh INSTANCE = new SshBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class SshImpl
    extends AbstractAugmentable<Ssh>
    implements Ssh {
        private final NetconfClientParameters _netconfClientParameters;
        private final SshClientParameters _sshClientParameters;
        private final TcpServerParameters _tcpServerParameters;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SshImpl(SshBuilder base) {
            super(base.augmentation);
            this._netconfClientParameters = base.getNetconfClientParameters();
            this._sshClientParameters = base.getSshClientParameters();
            this._tcpServerParameters = base.getTcpServerParameters();
        }

        @Override
        public NetconfClientParameters getNetconfClientParameters() {
            return this._netconfClientParameters;
        }

        @Override
        public SshClientParameters getSshClientParameters() {
            return this._sshClientParameters;
        }

        @Override
        public TcpServerParameters getTcpServerParameters() {
            return this._tcpServerParameters;
        }

        @Override
        public NetconfClientParameters nonnullNetconfClientParameters() {
            return Objects.requireNonNullElse(this.getNetconfClientParameters(), NetconfClientParametersBuilder.empty());
        }

        @Override
        public SshClientParameters nonnullSshClientParameters() {
            return Objects.requireNonNullElse(this.getSshClientParameters(), SshClientParametersBuilder.empty());
        }

        @Override
        public TcpServerParameters nonnullTcpServerParameters() {
            return Objects.requireNonNullElse(this.getTcpServerParameters(), TcpServerParametersBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Ssh.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Ssh.bindingEquals(this, obj);
        }

        public String toString() {
            return Ssh.bindingToString(this);
        }
    }
}

