/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.initiate.stack.grouping.transport.ssh.ssh.TcpClientParameters;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.tcp.client.grouping.ProxyServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.common.rev241010.TcpCommonGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.common.rev241010.tcp.common.grouping.Keepalives;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class TcpClientParametersBuilder {
    private Keepalives _keepalives;
    private IpAddress _localAddress;
    private PortNumber _localPort;
    private ProxyServer _proxyServer;
    private Host _remoteAddress;
    private PortNumber _remotePort;
    Map<Class<? extends Augmentation<TcpClientParameters>>, Augmentation<TcpClientParameters>> augmentation = Map.of();

    public TcpClientParametersBuilder() {
    }

    public TcpClientParametersBuilder(TcpClientGrouping arg) {
        this._remoteAddress = arg.getRemoteAddress();
        this._remotePort = arg.getRemotePort();
        this._localAddress = arg.getLocalAddress();
        this._localPort = arg.getLocalPort();
        this._proxyServer = arg.getProxyServer();
        this._keepalives = arg.getKeepalives();
    }

    public TcpClientParametersBuilder(TcpCommonGrouping arg) {
        this._keepalives = arg.getKeepalives();
    }

    public TcpClientParametersBuilder(TcpClientParameters base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TcpClientParameters>>, Augmentation<TcpClientParameters>>(aug);
        }
        this._keepalives = base.getKeepalives();
        this._localAddress = base.getLocalAddress();
        this._localPort = base.getLocalPort();
        this._proxyServer = base.getProxyServer();
        this._remoteAddress = base.getRemoteAddress();
        this._remotePort = base.getRemotePort();
    }

    public void fieldsFrom(Grouping arg) {
        TcpClientGrouping castArg;
        boolean isValidArg = false;
        if (arg instanceof TcpClientGrouping) {
            castArg = (TcpClientGrouping)arg;
            this._remoteAddress = castArg.getRemoteAddress();
            this._remotePort = castArg.getRemotePort();
            this._localAddress = castArg.getLocalAddress();
            this._localPort = castArg.getLocalPort();
            this._proxyServer = castArg.getProxyServer();
            isValidArg = true;
        }
        if (arg instanceof TcpCommonGrouping) {
            castArg = (TcpCommonGrouping)arg;
            this._keepalives = castArg.getKeepalives();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[TcpClientGrouping, TcpCommonGrouping]");
    }

    public static @NonNull TcpClientParameters empty() {
        return LazyEmpty.INSTANCE;
    }

    public Keepalives getKeepalives() {
        return this._keepalives;
    }

    public IpAddress getLocalAddress() {
        return this._localAddress;
    }

    public PortNumber getLocalPort() {
        return this._localPort;
    }

    public ProxyServer getProxyServer() {
        return this._proxyServer;
    }

    public Host getRemoteAddress() {
        return this._remoteAddress;
    }

    public PortNumber getRemotePort() {
        return this._remotePort;
    }

    public <E$$ extends Augmentation<TcpClientParameters>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TcpClientParametersBuilder setKeepalives(Keepalives value) {
        this._keepalives = value;
        return this;
    }

    public TcpClientParametersBuilder setLocalAddress(IpAddress value) {
        this._localAddress = value;
        return this;
    }

    public TcpClientParametersBuilder setLocalPort(PortNumber value) {
        this._localPort = value;
        return this;
    }

    public TcpClientParametersBuilder setProxyServer(ProxyServer value) {
        this._proxyServer = value;
        return this;
    }

    public TcpClientParametersBuilder setRemoteAddress(Host value) {
        this._remoteAddress = value;
        return this;
    }

    public TcpClientParametersBuilder setRemotePort(PortNumber value) {
        this._remotePort = value;
        return this;
    }

    public TcpClientParametersBuilder addAugmentation(Augmentation<TcpClientParameters> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TcpClientParameters>>, Augmentation<TcpClientParameters>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TcpClientParametersBuilder removeAugmentation(Class<? extends Augmentation<TcpClientParameters>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TcpClientParameters build() {
        return new TcpClientParametersImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull TcpClientParameters INSTANCE = new TcpClientParametersBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class TcpClientParametersImpl
    extends AbstractAugmentable<TcpClientParameters>
    implements TcpClientParameters {
        private final Keepalives _keepalives;
        private final IpAddress _localAddress;
        private final PortNumber _localPort;
        private final ProxyServer _proxyServer;
        private final Host _remoteAddress;
        private final PortNumber _remotePort;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TcpClientParametersImpl(TcpClientParametersBuilder base) {
            super(base.augmentation);
            this._keepalives = base.getKeepalives();
            this._localAddress = base.getLocalAddress();
            this._localPort = base.getLocalPort();
            this._proxyServer = base.getProxyServer();
            this._remoteAddress = base.getRemoteAddress();
            this._remotePort = base.getRemotePort();
        }

        public Keepalives getKeepalives() {
            return this._keepalives;
        }

        public IpAddress getLocalAddress() {
            return this._localAddress;
        }

        public PortNumber getLocalPort() {
            return this._localPort;
        }

        public ProxyServer getProxyServer() {
            return this._proxyServer;
        }

        public Host getRemoteAddress() {
            return this._remoteAddress;
        }

        public PortNumber getRemotePort() {
            return this._remotePort;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TcpClientParameters.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TcpClientParameters.bindingEquals(this, obj);
        }

        public String toString() {
            return TcpClientParameters.bindingToString(this);
        }
    }
}

