/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.NetconfServer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.NetconfServerKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.ConnectionType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.ConnectionTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.Endpoints;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.EndpointsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.ReconnectStrategy;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.client.rev240814.netconf.client.app.grouping.initiate.netconf.server.ReconnectStrategyBuilder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class NetconfServerBuilder {
    private ConnectionType _connectionType;
    private Endpoints _endpoints;
    private String _name;
    private ReconnectStrategy _reconnectStrategy;
    private NetconfServerKey key;
    Map<Class<? extends Augmentation<NetconfServer>>, Augmentation<NetconfServer>> augmentation = Map.of();

    public NetconfServerBuilder() {
    }

    public NetconfServerBuilder(NetconfServer base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfServer>>, Augmentation<NetconfServer>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._connectionType = base.getConnectionType();
        this._endpoints = base.getEndpoints();
        this._reconnectStrategy = base.getReconnectStrategy();
    }

    public NetconfServerKey key() {
        return this.key;
    }

    public ConnectionType getConnectionType() {
        return this._connectionType;
    }

    public Endpoints getEndpoints() {
        return this._endpoints;
    }

    public String getName() {
        return this._name;
    }

    public ReconnectStrategy getReconnectStrategy() {
        return this._reconnectStrategy;
    }

    public <E$$ extends Augmentation<NetconfServer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetconfServerBuilder withKey(NetconfServerKey key) {
        this.key = key;
        return this;
    }

    public NetconfServerBuilder setConnectionType(ConnectionType value) {
        this._connectionType = value;
        return this;
    }

    public NetconfServerBuilder setEndpoints(Endpoints value) {
        this._endpoints = value;
        return this;
    }

    public NetconfServerBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public NetconfServerBuilder setReconnectStrategy(ReconnectStrategy value) {
        this._reconnectStrategy = value;
        return this;
    }

    public NetconfServerBuilder addAugmentation(Augmentation<NetconfServer> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NetconfServer>>, Augmentation<NetconfServer>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NetconfServerBuilder removeAugmentation(Class<? extends Augmentation<NetconfServer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull NetconfServer build() {
        return new NetconfServerImpl(this);
    }

    private static final class NetconfServerImpl
    extends AbstractEntryObject<NetconfServer, NetconfServerKey>
    implements NetconfServer {
        private final ConnectionType _connectionType;
        private final Endpoints _endpoints;
        private final String _name;
        private final ReconnectStrategy _reconnectStrategy;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfServerImpl(NetconfServerBuilder base) {
            super(base.augmentation, (Key)NetconfServerImpl.extractKey(base));
            NetconfServerKey key = (NetconfServerKey)this.key();
            this._name = key.getName();
            this._connectionType = base.getConnectionType();
            this._endpoints = base.getEndpoints();
            this._reconnectStrategy = base.getReconnectStrategy();
        }

        private static @NonNull NetconfServerKey extractKey(NetconfServerBuilder base) {
            NetconfServerKey key = base.key();
            return key != null ? key : new NetconfServerKey(base.getName());
        }

        @Override
        public ConnectionType getConnectionType() {
            return this._connectionType;
        }

        @Override
        public Endpoints getEndpoints() {
            return this._endpoints;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public ReconnectStrategy getReconnectStrategy() {
            return this._reconnectStrategy;
        }

        @Override
        public ConnectionType nonnullConnectionType() {
            return Objects.requireNonNullElse(this.getConnectionType(), ConnectionTypeBuilder.empty());
        }

        @Override
        public Endpoints nonnullEndpoints() {
            return Objects.requireNonNullElse(this.getEndpoints(), EndpointsBuilder.empty());
        }

        @Override
        public ReconnectStrategy nonnullReconnectStrategy() {
            return Objects.requireNonNullElse(this.getReconnectStrategy(), ReconnectStrategyBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NetconfServer.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NetconfServer.bindingEquals(this, obj);
        }

        public String toString() {
            return NetconfServer.bindingToString(this);
        }
    }
}

