/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import com.google.common.base.Preconditions;
import java.util.List;
import org.checkerframework.checker.index.qual.NonNegative;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.conf.NetconfClientConfiguration;
import org.opendaylight.netconf.nettyutil.NetconfSessionNegotiator;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.TlsClientGrouping;

public final class NetconfClientConfigurationBuilder {
    public static final int DEFAULT_CONNECTION_TIMEOUT_MILLIS = 5000;
    public static final NetconfClientConfiguration.NetconfClientProtocol DEFAULT_CLIENT_PROTOCOL = NetconfClientConfiguration.NetconfClientProtocol.TCP;
    private long connectionTimeoutMillis = 5000L;
    private @NonNegative int maximumIncomingChunkSize = NetconfSessionNegotiator.DEFAULT_MAXIMUM_INCOMING_CHUNK_SIZE;
    private NetconfHelloMessageAdditionalHeader additionalHeader;
    private NetconfClientSessionListener sessionListener;
    private NetconfClientConfiguration.NetconfClientProtocol clientProtocol = DEFAULT_CLIENT_PROTOCOL;
    private List<Uri> odlHelloCapabilities;
    private String name;
    private TcpClientGrouping tcpParameters;
    private TlsClientGrouping tlsParameters;
    private SslHandlerFactory sslHandlerFactory;
    private SshClientGrouping sshParameters;
    private ClientFactoryManagerConfigurator sshConfigurator;

    private NetconfClientConfigurationBuilder() {
    }

    public static NetconfClientConfigurationBuilder create() {
        return new NetconfClientConfigurationBuilder();
    }

    public NetconfClientConfigurationBuilder withConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    public NetconfClientConfigurationBuilder withProtocol(NetconfClientConfiguration.NetconfClientProtocol clientProtocol) {
        this.clientProtocol = clientProtocol;
        return this;
    }

    public NetconfClientConfigurationBuilder withAdditionalHeader(NetconfHelloMessageAdditionalHeader additionalHeader) {
        this.additionalHeader = additionalHeader;
        return this;
    }

    public NetconfClientConfigurationBuilder withSessionListener(NetconfClientSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public NetconfClientConfigurationBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public NetconfClientConfigurationBuilder withOdlHelloCapabilities(List<Uri> odlHelloCapabilities) {
        this.odlHelloCapabilities = odlHelloCapabilities;
        return this;
    }

    public NetconfClientConfigurationBuilder withMaximumIncomingChunkSize(@NonNegative int maximumIncomingChunkSize) {
        Preconditions.checkArgument((maximumIncomingChunkSize > 0 ? 1 : 0) != 0);
        this.maximumIncomingChunkSize = maximumIncomingChunkSize;
        return this;
    }

    public NetconfClientConfigurationBuilder withTcpParameters(TcpClientGrouping tcpParameters) {
        this.tcpParameters = tcpParameters;
        return this;
    }

    public NetconfClientConfigurationBuilder withTlsParameters(TlsClientGrouping tlsParameters) {
        this.tlsParameters = tlsParameters;
        return this;
    }

    public NetconfClientConfigurationBuilder withSslHandlerFactory(SslHandlerFactory sslHandlerFactory) {
        this.sslHandlerFactory = sslHandlerFactory;
        return this;
    }

    public NetconfClientConfigurationBuilder withSshParameters(SshClientGrouping sshParameters) {
        this.sshParameters = sshParameters;
        return this;
    }

    public NetconfClientConfigurationBuilder withSshConfigurator(ClientFactoryManagerConfigurator sshConfigurator) {
        this.sshConfigurator = sshConfigurator;
        return this;
    }

    public NetconfClientConfiguration build() {
        return new NetconfClientConfiguration(this.clientProtocol, this.tcpParameters, this.tlsParameters, this.sslHandlerFactory, this.sshParameters, this.sshConfigurator, this.sessionListener, this.odlHelloCapabilities, this.connectionTimeoutMillis, this.maximumIncomingChunkSize, this.additionalHeader, this.name);
    }
}

