/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.conf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.index.qual.NonNegative;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.messages.NetconfHelloMessageAdditionalHeader;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.transport.ssh.ClientFactoryManagerConfigurator;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.ssh.client.rev241010.SshClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.TlsClientGrouping;

public final class NetconfClientConfiguration {
    private final @NonNull NetconfClientProtocol clientProtocol;
    private final Long connectionTimeoutMillis;
    private final NetconfHelloMessageAdditionalHeader additionalHeader;
    private final NetconfClientSessionListener sessionListener;
    private final List<Uri> odlHelloCapabilities;
    private final @NonNegative int maximumIncomingChunkSize;
    private final String name;
    private final TcpClientGrouping tcpParameters;
    private final TlsClientGrouping tlsParameters;
    private final SslHandlerFactory sslHandlerFactory;
    private final SshClientGrouping sshParameters;
    private final ClientFactoryManagerConfigurator sshConfigurator;

    NetconfClientConfiguration(NetconfClientProtocol protocol, TcpClientGrouping tcpParameters, TlsClientGrouping tlsParameters, SslHandlerFactory sslHandlerFactory, SshClientGrouping sshParameters, ClientFactoryManagerConfigurator sshConfigurator, NetconfClientSessionListener sessionListener, List<Uri> odlHelloCapabilities, Long connectionTimeoutMillis, @NonNegative int maximumIncomingChunkSize, NetconfHelloMessageAdditionalHeader additionalHeader, String name) {
        this.clientProtocol = Objects.requireNonNull(protocol);
        this.name = name;
        this.tcpParameters = Objects.requireNonNull(tcpParameters);
        this.tlsParameters = tlsParameters;
        this.sslHandlerFactory = sslHandlerFactory;
        this.sshParameters = sshParameters;
        this.sshConfigurator = sshConfigurator;
        this.sessionListener = Objects.requireNonNull(sessionListener);
        this.odlHelloCapabilities = odlHelloCapabilities;
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.maximumIncomingChunkSize = maximumIncomingChunkSize;
        this.additionalHeader = additionalHeader;
        if (NetconfClientProtocol.TLS.equals((Object)protocol)) {
            Preconditions.checkArgument((tlsParameters != null || sslHandlerFactory != null ? 1 : 0) != 0, (Object)"Either tlsParameters or sslHandlerFactory is required");
        } else if (NetconfClientProtocol.SSH.equals((Object)protocol)) {
            Objects.requireNonNull(sshParameters);
        }
    }

    public String getName() {
        return this.name;
    }

    public Long getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public Optional<NetconfHelloMessageAdditionalHeader> getAdditionalHeader() {
        return Optional.ofNullable(this.additionalHeader);
    }

    public NetconfClientSessionListener getSessionListener() {
        return this.sessionListener;
    }

    public @NonNull NetconfClientProtocol getProtocol() {
        return this.clientProtocol;
    }

    public SslHandlerFactory getSslHandlerFactory() {
        return this.sslHandlerFactory;
    }

    public List<Uri> getOdlHelloCapabilities() {
        return this.odlHelloCapabilities;
    }

    public @NonNegative int getMaximumIncomingChunkSize() {
        return this.maximumIncomingChunkSize;
    }

    public TcpClientGrouping getTcpParameters() {
        return this.tcpParameters;
    }

    public TlsClientGrouping getTlsParameters() {
        return this.tlsParameters;
    }

    public SshClientGrouping getSshParameters() {
        return this.sshParameters;
    }

    public ClientFactoryManagerConfigurator getSshConfigurator() {
        return this.sshConfigurator;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientProtocol", (Object)this.clientProtocol).add("connectionTimeoutMillis", (Object)this.connectionTimeoutMillis).add("additionalHeader", (Object)this.additionalHeader).add("sessionListener", (Object)this.sessionListener).add("tcpParameters", (Object)this.tcpParameters).add("tlsParameters", (Object)this.tlsParameters).add("sshParameters", (Object)this.sshParameters).add("sslHandlerFactory (defined)", this.sslHandlerFactory != null).add("sslHandlerFactory (defined)", this.sshConfigurator != null).toString();
    }

    public static enum NetconfClientProtocol {
        TCP,
        SSH,
        TLS;

    }
}

